package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.service.IInvestigateModleService;
import com.ejianc.business.pro.supplier.vo.InvExpertLeaderVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("canIn") 
public class CanInBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICanInService service;

	@Autowired
	private ISupplierApi iProSupplierApi;

	@Autowired
	private IInvExpertService iInvExpertService;

	@Autowired
	private IInvExpertLeaderService iInvExpertLeaderService;

	@Autowired
	private IBillCodeApi billCodeApi;

	@Autowired
	private IInvestigateModleService iInvestigateModleService;

	@Autowired
	private IPushMessageApi pushMessageApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CanInEntity canInEntity = service.selectById(billId);
		if(canInEntity == null){
			return CommonResponse.error("没有查到该准入单！");
		}
		if(canInEntity.getInvestigate() != null && canInEntity.getInvestigate()){
			//需要考察
			if(ListUtil.isEmpty(canInEntity.getExportList())){
				return CommonResponse.error("该准入单,需要考察，请添加考察专家！");
			}
			boolean noLeader = true;
			int num = 0;
			for (CanInExpertEntity expertEntity : canInEntity.getExportList()) {
				if(expertEntity.getLeader()){
					noLeader = false;
					num++;
				}
			}
			if(noLeader){
				return CommonResponse.error("该准入单,需要考察，考察专家需要有一个组长！");
			}
			if(num>1){
				return CommonResponse.error("该准入单,需要考察，考察专家只能有一个组长！");
			}
		}
		QueryParam param = new QueryParam();
		param.getParams().put("id",new Parameter(QueryParam.NE,billId));

		param.getParams().put("socialCreditCode",new Parameter(QueryParam.EQ,canInEntity.getSocialCreditCode()));
		List<CanInEntity> canInEntities = service.queryList(param);

		if(CollectionUtils.isNotEmpty(canInEntities)){
			if("p".equals(canInEntity.getPersonal())) {
				return CommonResponse.error("供应商库已存在身份证号为【"+canInEntity.getSocialCreditCode()+"】的个人供应商！");
			}else {
				return CommonResponse.error("供应商库已存在统一社会信用代码为【"+canInEntity.getSocialCreditCode()+"】的企业供应商！");
			}
		}
		logger.info("canInEntity:{}",JSONObject.toJSONString(canInEntity));
		CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(canInEntity.getSocialCreditCode(),"e");
		if(!exist.isSuccess()){
			return exist;
		}

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO  根据是否需要考察 分为需要考察和不需要考察，不需要考察需要推送到共享中心供方档案
		CanInEntity canInEntity = service.selectById(billId);
		if(canInEntity == null){
			return CommonResponse.error("没有查到该准入单！");
		}
		//
		if(canInEntity.getInvestigate() == null || !canInEntity.getInvestigate()){
			//不需要考察 推送到共享中心
			return service.pushSupplierToShare(canInEntity,billTypeCode);

		}else {
			//需要考察 推送生成 专家考察列表 和汇总列表
			InvExpertLeaderEntity leaderEntity = new InvExpertLeaderEntity();
			BillCodeParam billCodeParam = BillCodeParam.build("INVESTIGATE-EX", InvocationInfoProxy.getTenantid(),BeanMapper.map(leaderEntity, InvExpertLeaderVO.class));
			CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
			leaderEntity.setId(IdWorker.getId());
			if(billCode.isSuccess()) {
				leaderEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
			}else{
				leaderEntity.setCode(("HZ-"+ IdWorker.getId()).substring(0,8));//此处需要根据实际修改 删除本行或者下一行
			}
			leaderEntity.setCanInId(billId);
			leaderEntity.setBillState(0);
			leaderEntity.setSupplierName(canInEntity.getName());
			leaderEntity.setApplyOrgId(canInEntity.getOrgId());
			leaderEntity.setApplyOrgName(canInEntity.getOrgName());
			for (CanInExpertEntity expertEntity : canInEntity.getExportList()) {
				if(expertEntity.getLeader()){
					leaderEntity.setLeader(expertEntity.getExpertName());
					leaderEntity.setLeaderId(expertEntity.getExpertId());
				}
			}
			leaderEntity.setExportIds(Strings.join(canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertId).collect(Collectors.toList()), ','));
			leaderEntity.setExportNames(Strings.join(canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertName).collect(Collectors.toList()), ','));
			leaderEntity.setSchedule("0/"+canInEntity.getExportList().size());
			leaderEntity.setStartDate(new Date());
			leaderEntity.setScore(0);
			leaderEntity.setResult("不合格");
			leaderEntity.setGradeId(canInEntity.getGradeId());
			List<InvestigateModleContentEntity> modelContentEntities = iInvestigateModleService.queryTypeName(canInEntity.getEnterpriseType());
			if(ListUtil.isEmpty(modelContentEntities)){
				return CommonResponse.error("未找到【"+canInEntity.getEnterpriseType()+"】对应的考察模板，请联系管理员配置！");
			}
			iInvExpertLeaderService.saveOrUpdate(leaderEntity,false);
			for (CanInExpertEntity canInExpertEntity : canInEntity.getExportList()) {
				InvExpertEntity expertEntity = BeanMapper.map(leaderEntity,InvExpertEntity.class);
				expertEntity.setId(IdWorker.getId());
				expertEntity.setCollectId(leaderEntity.getId());
				billCode = billCodeApi.generateBillCode(billCodeParam);
				if(billCode.isSuccess()) {
					expertEntity.setCode(billCode.getData());
				}else{
					expertEntity.setCode(("HZ-"+ IdWorker.getId()).substring(0,8));
				}
				expertEntity.setCanSubId(canInExpertEntity.getId());
				expertEntity.setExportId(canInExpertEntity.getExpertId());
				expertEntity.setExportName(canInExpertEntity.getExpertName());
				expertEntity.setState("1");
				expertEntity.setScore(0);
				for (InvestigateModleContentEntity modelContentEntity : modelContentEntities) {
					InvestigateContentEntity contentEntity = BeanMapper.map(modelContentEntity,InvestigateContentEntity.class);
					contentEntity.setId(IdWorker.getId());
					contentEntity.setPid(expertEntity.getId());
					contentEntity.setSubScore("0");
					expertEntity.getInvestigateContentEntities().add(contentEntity);
				}
				iInvExpertService.saveOrUpdateNoES(expertEntity);
			}
			/** 发送消息 */
			PushMsgParameter parameter = new PushMsgParameter();
			List<String> channel = new ArrayList<>();
			// 系统消息
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
			channel.add(PushMsgParameter.CHANNEL_TYPE_DINGDING);
			JSONObject dingdingParams = new JSONObject();
			dingdingParams.put("maurl", "");
			dingdingParams.put("pcurl", "");
			dingdingParams.put("title", "您有一条新的供应商考察信息，供应商名称：【"+canInEntity.getName()+"】,请及时登录系统处理。");
			dingdingParams.put("content", "您有一条新的供应商考察信息，供应商名称：【"+canInEntity.getName()+"】,请及时登录系统处理。");
			parameter.setDingdingParams(dingdingParams);
			parameter.setReceivers(canInEntity.getExportList().stream().map(CanInExpertEntity::getExpertId).map(String::valueOf).toArray(String[]::new));// 收信人
			parameter.setChannel(channel.toArray(new String[0]));// 消息类型
			parameter.setMsgType("notice");
			parameter.setSubject("您有一条新的供应商考察信息，供应商名称：【"+canInEntity.getName()+"】,请及时登录系统处理。");// 标题
			parameter.setContent( "您有一条新的供应商考察信息，供应商名称：【"+canInEntity.getName()+"】,请及时登录系统处理。");// 内容
			parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
			parameter.setSendUserId(InvocationInfoProxy.getUserid());
			try {
				CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
				if (result.isSuccess()) {
					logger.error("消息发送成功---------------->" + result.getMsg());
				} else {
					logger.error("消息发送失败---------------->" + result.getMsg());
				}
			} catch (Exception e) {
				logger.error("调用消息中心RPC服务异常--------------" + e);
			}

		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持撤回或者弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
