package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.List;
import java.util.Objects;

@Service("invExpertLeader") 
public class InvExpertLeaderBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IInvExpertService iInvExpertService;

	@Autowired
	private IInvExpertLeaderService invExpertLeaderService;

	@Autowired
	private ICanInService canInService;

	@Autowired
	private IGradeService iGradeService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		InvExpertLeaderEntity leaderEntity = invExpertLeaderService.selectById(billId);
		if(leaderEntity == null){
			return CommonResponse.error("没找到该单据！");
		}

		QueryParam param = new QueryParam();
		param.getParams().put("canInId",new Parameter(QueryParam.EQ, leaderEntity.getCanInId()));
		List<InvExpertEntity> list = iInvExpertService.queryList(param);
		for (InvExpertEntity expertEntity : list) {
			if(!"2".equals(expertEntity.getState())){
				return CommonResponse.error("所有专家必须完成考察，才能进行汇总提交！");
			}
		}

		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		InvExpertLeaderEntity leaderEntity = invExpertLeaderService.selectById(billId);
		if(leaderEntity == null){
			return CommonResponse.error("没找到该单据！");
		}

		QueryParam param = new QueryParam();
		param.getParams().put("canInId",new Parameter(QueryParam.EQ, leaderEntity.getCanInId()));
		List<InvExpertEntity> list = iInvExpertService.queryList(param);
		logger.info("审批流提交---根据考察规则，提交后将非已考察置为已过期！billId-{},canInId-{}",billId,leaderEntity.getCanInId());
		for (InvExpertEntity expertEntity : list) {
			if(!"2".equals(expertEntity.getState())){
				/** 置为已过期 */
				expertEntity.setState("4");
				logger.info("审批流提交---根据考察规则，提交后将非已考察置为已过期！专家-{},编码-{}",expertEntity.getExportName(),expertEntity.getCode());
				iInvExpertService.saveOrUpdateNoES(expertEntity);
			}
		}
		leaderEntity.setSubmitDate(new Date());
		invExpertLeaderService.saveOrUpdate(leaderEntity);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		InvExpertLeaderEntity entity = invExpertLeaderService.selectById(billId);
		if(entity == null){
			return CommonResponse.error("没找到该单据！");
		}
		Long canInId = entity.getCanInId();
		Long gradeId = entity.getGradeId();
		if(state == 1){
			/** 直审通过 */
			QueryParam param = new QueryParam();
			param.getParams().put("collectId",new Parameter(QueryParam.EQ, billId));
			List<InvExpertEntity> list = iInvExpertService.queryList(param);
			for (InvExpertEntity expertEntity : list) {
				if(!"2".equals(expertEntity.getState())){
					return CommonResponse.error("所有专家必须完成考察，才能进行汇总提交！");
				}
			}
			logger.info("直审提交 --- 根据考察规则，提交后将非已考察置为已过期！billId-{},canInId-{}",billId,canInId);
			for (InvExpertEntity expertEntity : list) {
				if(!"2".equals(expertEntity.getState())){
					/** 置为已过期 */
					expertEntity.setState("4");
					logger.info("直审提交 --- 根据考察规则，提交后将非已考察置为已过期！专家-{},编码-{}",expertEntity.getExportName(),expertEntity.getCode());
					iInvExpertService.saveOrUpdateNoES(expertEntity);
				}
			}
			entity.setSubmitDate(new Date());
			invExpertLeaderService.saveOrUpdate(entity);
		}

		String gradeName = iGradeService.selectById(gradeId).getName();
		if("合格".equals(entity.getResult())){
			//合格推共享中心
			return canInService.afterInvestigate(canInId,gradeId,gradeName);
		}else{
			//不合格，恢复自由态，以便于下次继续考察
			CanInEntity canInEntity =canInService.selectById(canInId);
			canInEntity.setBillState(0);
			canInService.saveOrUpdate(canInEntity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("不支持驳回或者弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
