package com.ejianc.business.pro.supplier.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.pro.supplier.bean.InvestigateContentEntity;
/**
 * 供应商考察主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_investigate")
public class InvestigateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code;
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名称
    @TableField(value="date")
    private java.util.Date date; // 考察日期
    @TableField(value="score")
    private java.lang.String score; // 考察得分
    @TableField(value="memo")
    private java.lang.String memo; // 综合评价
    @TableField(value="can_in_id")
    private java.lang.Long canInId; // 准入表id
    @TableField(value="investigate_results")
    private java.lang.String investigateResults;//考察结果 合格pass  不合格noPass
    @TableField(value="supply_content")
    private String supplyContent; // 供货内容
    @TableField(value="enterprise_type")
    private String enterpriseType; // 制造商：maker,经销商：seller
    @TableField(value="state")
    private String state; // 考察状态：to待考察，did已考察

    @TableField(exist=false)
    @SubEntity(serviceName="investigateContentService")
    private List<InvestigateContentEntity> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getScore() {
        return score;
    }

    public void setScore(String score) {
        this.score = score;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }

    public String getInvestigateResults() {
        return investigateResults;
    }

    public void setInvestigateResults(String investigateResults) {
        this.investigateResults = investigateResults;
    }

    public List<InvestigateContentEntity> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public String getSupplyContent() {
        return supplyContent;
    }

    public void setSupplyContent(String supplyContent) {
        this.supplyContent = supplyContent;
    }

    public String getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(String enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setInvestigateContentEntities(List<InvestigateContentEntity> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }
}
