package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.mapper.YearMapper;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 年度评价
 * 
 * @author generator
 * 
 */
@Service("yearService")
public class YearServiceImpl extends BaseServiceImpl<YearMapper, YearEntity> implements IYearService{


    @Autowired
    private YearMapper yearMapper;

    @Override
    public Map<Long, Integer> queryGrade(Map<String, List<Long>> map) {
        List<Long> suplyIds = map.get("suplyIds");
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        Map<Long,Integer> resultMap = new HashMap<>();
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(),item.getYearDeduct());
        });
        return resultMap;
    }

    @Override
    public Map<Long, BigDecimal> queryTotalBranch(Map<String, List<Long>> map) {
        Map<Long,BigDecimal> resultMap = new HashMap<>();
        List<Long> suplyIds = map.get("suplyIds");
        if(CollectionUtils.isEmpty(suplyIds)) {
            return resultMap;
        }
        List<YearEntity> yearEntities = yearMapper.queryGrade(suplyIds);
        yearEntities.forEach(item->{
            resultMap.put(item.getSupplyId(), item.getTotalBranch());
        });
        return resultMap;
    }
}
