/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.bean.YearEntity;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.IYearService;
import com.ejianc.business.pro.supplier.vo.UpgradePJVO;
import com.ejianc.business.pro.supplier.vo.YearVO;
import com.ejianc.business.pro.supplier.vo.appraise.ResultContVo;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"year"})
public class YearController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    private static final String BILL_CODE = "YEAY_EVALUATE";
    @Autowired
    private IYearService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISupplierApi iSupplierApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<YearVO> saveOrUpdate(@RequestBody YearVO saveorUpdateVO) {
        YearEntity entity = (YearEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, YearEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        CommonResponse voCommonResponse = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (voCommonResponse.isSuccess()) {
            UserVO user = (UserVO)voCommonResponse.getData();
            entity.setCreateUserName(user.getUserName());
            entity.setPhone(user.getUserMobile());
        }
        entity.setOrgId(this.sessionManager.getUserContext().getOrgId());
        entity.setOrgCode(this.sessionManager.getUserContext().getOrgCode());
        entity.setOrgName(this.sessionManager.getUserContext().getOrgName());
        this.service.saveOrUpdate((Object)entity, false);
        YearVO vo = (YearVO)BeanMapper.map((Object)((Object)entity), YearVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<YearVO> queryDetail(Long id) {
        YearEntity entity = (YearEntity)((Object)this.service.selectById(id));
        YearVO vo = (YearVO)BeanMapper.map((Object)((Object)entity), YearVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<YearVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<YearVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("cooperationOrgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YearVO.class));
        List records = pageData.getRecords();
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplyName");
        fuzzyFields.add("cooperationOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, YearVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        String exportFileName = "Year-materialEquipment-export.xlsx";
        if ("other".equals(((Parameter)param.getParams().get("supplyQueryType")).getInputType())) {
            exportFileName = "Year-other-export.xlsx";
        }
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }

    @RequestMapping(value={"/refYearData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<YearVO>> refYearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), YearVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryRecordList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ResultContVo>> queryRecordList(Long id, Long supplyId) {
        YearEntity yearEntity = (YearEntity)((Object)this.service.selectById(id));
        ResultContVo resultContVo = new ResultContVo();
        ArrayList<ResultContVo> result = new ArrayList<ResultContVo>();
        result.add(resultContVo);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/queryListBySupplierId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<UpgradePJVO>> queryListBySupplierId(@RequestBody QueryParam param) {
        CommonResponse response;
        param.getFuzzyFields().add("checkOrgName");
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        Long supplyId = Long.valueOf(((Parameter)param.getParams().get("supplyId")).getValue().toString());
        supplierIds.add(supplyId);
        if ("999999".equals(InvocationInfoProxy.getTenantid().toString()) && (response = this.iSupplierApi.getReferSupplierIdsBySupplierId(supplyId)).isSuccess()) {
            supplierIds.addAll((Collection)response.getData());
        }
        param.getParams().put("supplyId", new Parameter("in", supplierIds));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.processService.queryPage(param, false);
        ArrayList<UpgradePJVO> resList = new ArrayList<UpgradePJVO>();
        for (ProcessEntity process : page.getRecords()) {
            UpgradePJVO upgradePJVO = new UpgradePJVO();
            upgradePJVO.setId(process.getId());
            upgradePJVO.setUnitName(process.getCheckOrgName());
            upgradePJVO.setType("\u4e8b\u4ef6\u8bc4\u4ef7");
            upgradePJVO.setDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)process.getDate()));
            upgradePJVO.setMemo(process.getMemo());
            resList.add(upgradePJVO);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(resList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

