/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"evaluateHistory"})
public class EvaluateHistoryController
implements Serializable {
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IPunishService punishService;

    @RequestMapping(value={"/evaluate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> evaluateHistory(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/history"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EvaluateHistoryVO>> history(Long supplyId) {
        List<EvaluateHistoryVO> list = this.processService.queryHistoryList(supplyId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/subcontractEvaluate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> subcontractEvaluate(String headUserName) {
        QueryParam param = new QueryParam();
        param.getParams().put("head_user_name", new Parameter("eq", (Object)headUserName));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/punish"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierPunish(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)supplyId));
        List list = this.punishService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/upgrades"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierUpgrades(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)supplyId));
        List list = this.punishService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }
}

