/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.InvExpertEntity;
import com.ejianc.business.pro.supplier.bean.InvExpertLeaderEntity;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.vo.InvExpertVO;
import com.ejianc.business.pro.supplier.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"invExpert"})
public class InvExpertController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IInvExpertService service;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IInvExpertLeaderService iInvExpertLeaderService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InvExpertVO> saveOrUpdate(@RequestBody InvExpertVO saveOrUpdateVO) {
        InvExpertEntity entity = (InvExpertEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, InvExpertEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        InvExpertVO vo = (InvExpertVO)BeanMapper.map((Object)((Object)entity), InvExpertVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvExpertVO> submit(@RequestParam Long id) {
        InvExpertEntity entity = (InvExpertEntity)((Object)this.service.getById(id));
        entity.setState("2");
        entity.setSubmitDate(new Date());
        QueryParam param = new QueryParam();
        this.service.saveOrUpdate((Object)entity, false);
        param.getParams().put("canInId", new Parameter("eq", (Object)entity.getCanInId()));
        List list = this.service.queryList(param);
        int score = 0;
        int num = 0;
        for (InvExpertEntity expertEntity : list) {
            if (!"2".equals(expertEntity.getState())) continue;
            score += expertEntity.getScore().intValue();
            ++num;
        }
        List leaderEntities = this.iInvExpertLeaderService.queryList(param, false);
        if (ListUtil.isEmpty((List)leaderEntities)) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u6c47\u603b\u5355\u636e\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        InvExpertLeaderEntity leaderEntity = (InvExpertLeaderEntity)((Object)leaderEntities.get(0));
        if (num > 0) {
            leaderEntity.setScore(score /= num);
            if (score > 69) {
                leaderEntity.setResult("\u5408\u683c");
            } else {
                leaderEntity.setResult("\u4e0d\u5408\u683c");
            }
            leaderEntity.setSchedule(num + "/" + list.size());
            if (num == list.size()) {
                this.sendMsg(leaderEntity.getSupplierName(), leaderEntity.getLeaderId());
            }
        } else {
            leaderEntity.setScore(0);
            leaderEntity.setResult("\u4e0d\u5408\u683c");
            leaderEntity.setSchedule("0/" + list.size());
        }
        this.iInvExpertLeaderService.saveOrUpdate((Object)leaderEntity, false);
        InvExpertVO vo = (InvExpertVO)BeanMapper.map((Object)((Object)entity), InvExpertVO.class);
        return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)vo);
    }

    private void sendMsg(String supplierName, Long userId) {
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        channel.add("sys");
        channel.add("dingding");
        JSONObject dingdingParams = new JSONObject();
        dingdingParams.put("maurl", (Object)"");
        dingdingParams.put("pcurl", (Object)"");
        dingdingParams.put("title", (Object)("\u3010" + supplierName + "\u3011\u6240\u6709\u4e13\u5bb6\u5df2\u5168\u90e8\u8003\u5bdf\u5b8c\u6bd5,\u8bf7\u53ca\u65f6\u6c47\u603b\u3002"));
        dingdingParams.put("content", (Object)("\u3010" + supplierName + "\u3011\u6240\u6709\u4e13\u5bb6\u5df2\u5168\u90e8\u8003\u5bdf\u5b8c\u6bd5,\u8bf7\u53ca\u65f6\u6c47\u603b\u3002"));
        parameter.setDingdingParams(dingdingParams);
        parameter.setReceivers(new String[]{userId.toString()});
        parameter.setChannel(channel.toArray(new String[0]));
        parameter.setMsgType("notice");
        parameter.setSubject("\u3010" + supplierName + "\u3011\u6240\u6709\u4e13\u5bb6\u5df2\u5168\u90e8\u8003\u5bdf\u5b8c\u6bd5,\u8bf7\u53ca\u65f6\u6c47\u603b\u3002");
        parameter.setContent("\u3010" + supplierName + "\u3011\u6240\u6709\u4e13\u5bb6\u5df2\u5168\u90e8\u8003\u5bdf\u5b8c\u6bd5,\u8bf7\u53ca\u65f6\u6c47\u603b\u3002");
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }

    @RequestMapping(value={"/reject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> reject(@RequestParam(value="id") Long id, @RequestParam(value="reason") String reason) {
        InvExpertEntity entity = (InvExpertEntity)((Object)this.service.getById(id));
        entity.setState("3");
        entity.setReason(reason);
        entity.setSubmitDate(null);
        this.service.saveOrUpdate((Object)entity, false);
        QueryParam param = new QueryParam();
        param.getParams().put("canInId", new Parameter("eq", (Object)entity.getCanInId()));
        List list = this.service.queryList(param);
        int num = 0;
        int score = 0;
        for (InvExpertEntity expertEntity : list) {
            if (!"2".equals(expertEntity.getState())) continue;
            ++num;
            score += expertEntity.getScore().intValue();
        }
        List leaderEntities = this.iInvExpertLeaderService.queryList(param, false);
        if (ListUtil.isEmpty((List)leaderEntities)) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u6c47\u603b\u5355\u636e\uff0c\u63d0\u4ea4\u5931\u8d25\uff01");
        }
        InvExpertLeaderEntity leaderEntity = (InvExpertLeaderEntity)((Object)leaderEntities.get(0));
        if (num > 0) {
            leaderEntity.setScore(score /= num);
            if (score > 69) {
                leaderEntity.setResult("\u5408\u683c");
            } else {
                leaderEntity.setResult("\u4e0d\u5408\u683c");
            }
            leaderEntity.setSchedule(num + "/" + list.size());
        } else {
            leaderEntity.setScore(0);
            leaderEntity.setSchedule("0/" + list.size());
            leaderEntity.setResult("\u4e0d\u5408\u683c");
        }
        this.iInvExpertLeaderService.saveOrUpdate((Object)leaderEntity, false);
        return CommonResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvExpertVO> queryDetail(Long id) {
        InvExpertEntity entity = (InvExpertEntity)((Object)this.service.selectById(id));
        InvExpertVO vo = (InvExpertVO)BeanMapper.map((Object)((Object)entity), InvExpertVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getInvestigateContentEntities())) {
            vo.setInvestigateContentEntities(TreeNodeBUtil.buildTree((List)vo.getInvestigateContentEntities()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InvExpertVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InvExpertVO invExpertVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InvExpertVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("exportNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("exportId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvExpertVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryForLeaderList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InvExpertVO>> queryForLeaderList(@RequestParam Long canInId) {
        QueryParam param = new QueryParam();
        param.getParams().put("canInId", new Parameter("eq", (Object)canInId));
        List page = this.service.queryList(param, false);
        List pageData = BeanMapper.mapList((Iterable)page, InvExpertVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("code");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyOrgName");
        fuzzyFields.add("exportNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("exportId", new Parameter("eq", (Object)InvocationInfoProxy.getUserid()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            List voList = BeanMapper.mapList((Iterable)list, InvExpertVO.class);
            for (InvExpertVO invExpertVO : voList) {
                invExpertVO.setMainBusiness(invExpertVO.getBusinessName(invExpertVO.getMainBusiness()));
                invExpertVO.setState(invExpertVO.getStateName(invExpertVO.getState()));
            }
            HashMap<String, List> beans = new HashMap<String, List>();
            beans.put("records", voList);
            ExcelExport.getInstance().export("expert-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refInvExpertData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InvExpertVO>> refInvExpertData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InvExpertVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

