/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.appraise.PushProcessLogic;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushProcessLogic")
public class PushProcessRuleALogic
implements PushProcessLogic {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        ArrayList<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty((CharSequence)contractType)) {
            ArrayList contractTypeList = new ArrayList();
            queryParam.getParams().put("sourceType", new Parameter("in", contractTypeList));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        ArrayList<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty((CharSequence)contractType)) {
            ArrayList contractTypeList = new ArrayList();
            queryParam.getParams().put("sourceType", new Parameter("in", contractTypeList));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> getAnnualIncidentPushList(AppraiseParamVO appraiseParamVO, String startDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractProperty", new Parameter("eq", (Object)0));
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        QueryWrapper incidentQuery = new QueryWrapper();
        incidentQuery.select(new String[]{"distinct(contract_id)"});
        incidentQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        incidentQuery.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        incidentQuery.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentIds = this.incidentService.listObjs((Wrapper)incidentQuery, item -> Long.valueOf(item.toString()));
        QueryWrapper processQuery = new QueryWrapper();
        processQuery.select(new String[]{"distinct(contract_id)"});
        processQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        processQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        processQuery.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        processQuery.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processIds = this.incidentService.listObjs((Wrapper)incidentQuery, item -> Long.valueOf(item.toString()));
        return null;
    }
}

