package com.ejianc.business.pro.change.service.impl;

import com.ejianc.business.pro.change.bean.*;
import com.ejianc.business.pro.change.service.IChangeBrandService;
import com.ejianc.business.pro.change.service.IChangeService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("change") 
public class ChangeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private ISupplierApi iSupplierApi;
	@Autowired
	private IChangeService service;
	@Autowired
	private IChangeBrandService changeBrandService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ChangeEntity entity = service.selectById(billId);
		if(entity == null){
			return CommonResponse.error("没有找到该供应商变更单!");
		}
		CommonResponse<SupplierVO> commonResponse =  iSupplierApi.getSupplierInfo(entity.getOriginId());
		if(!commonResponse.isSuccess()){
			return CommonResponse.error("供应商信息查询失败:"+commonResponse.getMsg());
		}
		if(commonResponse.getData()==null){
			return CommonResponse.error("供应商信息查询失败:供应商不存在！");
		}
		SupplierVO supplierVO = commonResponse.getData();
		supplierVO.setName(entity.getName());
		supplierVO.setEnterpriseNature(entity.getEnterpriseNature());
		supplierVO.setEnterpriseNatureName(entity.getEnterpriseNatureName());
		supplierVO.setEnterpriseType(entity.getEnterpriseType());
		supplierVO.setSocialCreditCode(entity.getSocialCreditCode());
		supplierVO.setAddress(entity.getAddress());
		supplierVO.setRegisterTime(entity.getRegisterTime());
		supplierVO.setRegisterCountryId(entity.getRegisterCountryId());
		supplierVO.setRegisterCountryName(entity.getRegisterCountryName());
		supplierVO.setLegal(entity.getLegal());
		supplierVO.setLegalPhone(entity.getLegalPhone());
		supplierVO.setBusinessPerson(entity.getBusinessPerson());
		supplierVO.setBusinessPhone(entity.getBusinessPhone());
		supplierVO.setTurnover(entity.getTurnover());
		supplierVO.setRegisteredCapital(entity.getRegisteredCapital());
		supplierVO.setSupplyContentId(entity.getSupplyContentId());
		supplierVO.setSupplyContent(entity.getSupplyContent());
		supplierVO.setBusinessScope(entity.getBusinessScope());
		supplierVO.setBlTime(entity.getBlTime());
		supplierVO.setTaxPayerType(entity.getTaxPayerType());
		supplierVO.setBillingAddress(entity.getBillingAddress());
		supplierVO.setBillingPhone(entity.getBillingPhone());
		supplierVO.setBankName(entity.getBankName());
		supplierVO.setRealFunds(entity.getRealFunds());
		supplierVO.setBankAccount(entity.getBankAccount());
		supplierVO.setAuthLevel(entity.getAuthLevel());
		supplierVO.setCurrencyType(entity.getCurrencyType());
		List<CertsVO> certs = supplierVO.getCerts();
		Map<Long, CertsVO> certsMap = new HashMap<>();
		for (CertsVO cert : certs) {
			certsMap.put(cert.getId(), cert);
		}
		List<ChangeCertsEntity> contactList = entity.getCerts();
		contactList.forEach(certChange -> {
			CertsVO cert =  certsMap.get(certChange.getOriginId());
			if(cert == null){
				/** 不存在 */
				if(certChange.getIsDel() == null || certChange.getIsDel() == 0){
					/** 没删除 */
					cert = BeanMapper.map(certChange, CertsVO.class);
					cert.setRowState("add");
					cert.setPid(supplierVO.getId());
					cert.setTenantId(999999L);
					cert.setUpdateUserCode(null);
					certs.add(cert);
				}
			}else {
				if(certChange.getIsDel() != null && certChange.getIsDel() == 1){
					cert.setRowState("del");
				}else {
					cert.setCertCode(certChange.getCertCode());
					cert.setCertName(certChange.getCertName());
					cert.setCertId(certChange.getCertId());
					cert.setAwardOrg(certChange.getAwardOrg());
					cert.setAwardDate(certChange.getAwardDate());
					cert.setTimeValidity(certChange.getTimeValidity());
				}
			}
		});
		supplierVO.setCerts(certs);

		List<BankVO> banks = supplierVO.getBanks();
		Map<Long, BankVO> bankMap = new HashMap<>();
		for (BankVO bank : banks) {
			bankMap.put(bank.getId(), bank);
		}
		List<ChangeBankEntity> bankList = entity.getBanks();
		bankList.forEach(changeBankEntity -> {
			BankVO bank = bankMap.get(changeBankEntity.getOriginId());
			if(bank == null){
				/** 不存在 */
				if(changeBankEntity.getIsDel() == null || changeBankEntity.getIsDel() == 0){
					/** 没删除 */
					bank = BeanMapper.map(changeBankEntity, BankVO.class);
					bank.setRowState("add");
					bank.setPid(supplierVO.getId());
					bank.setTenantId(999999L);
					bank.setUpdateUserCode(null);
					banks.add(bank);
				}
			}else {
				if(changeBankEntity.getIsDel() != null && changeBankEntity.getIsDel() == 1){
					bank.setRowState("del");
				}else {
					bank.setBankId(changeBankEntity.getBankId());
					bank.setBankCode(changeBankEntity.getBankCode());
					bank.setBankName(changeBankEntity.getBankName());
					bank.setAddress(changeBankEntity.getAddress());
					bank.setDefaultable(changeBankEntity.getDefaultable());
					bank.setBankAccount(changeBankEntity.getBankAccount());
					bank.setCategoryId(changeBankEntity.getCategoryId());
					bank.setCategoryName(changeBankEntity.getCategoryName());
				}
			}
		});
		supplierVO.setBanks(banks);

		List<ChangeFinanceReportEntity> financeReportList = entity.getFinanceReportList();
		Map<Long, FinanceReportVO> financeReportMap = new HashMap<>();
		List<FinanceReportVO> financeReportLists = supplierVO.getFinanceReportList();
		financeReportLists.forEach(financeReportVO -> financeReportMap.put(financeReportVO.getId(), financeReportVO));
		financeReportList.forEach(changeFinanceReportEntity -> {
			FinanceReportVO financeReportVO = financeReportMap.get(changeFinanceReportEntity.getOriginId());
			if(financeReportVO == null){
				if(changeFinanceReportEntity.getIsDel() == null || changeFinanceReportEntity.getIsDel() == 0){
					financeReportVO = BeanMapper.map(changeFinanceReportEntity, FinanceReportVO.class);
					financeReportVO.setRowState("add");
					financeReportVO.setPid(supplierVO.getId());
					financeReportVO.setTenantId(999999L);
					financeReportVO.setUpdateUserCode(null);
					financeReportLists.add(financeReportVO);
				}
			}else {
				if(changeFinanceReportEntity.getIsDel() != null && changeFinanceReportEntity.getIsDel() == 1){
					financeReportVO.setRowState("del");
				}else {
					financeReportVO.setYear(changeFinanceReportEntity.getYear());
					financeReportVO.setCurrencyId(changeFinanceReportEntity.getCurrencyId());
					financeReportVO.setCurrencyName(changeFinanceReportEntity.getCurrencyName());
					financeReportVO.setReceiveIn(changeFinanceReportEntity.getReceiveIn());
					financeReportVO.setProfit(changeFinanceReportEntity.getProfit());
					financeReportVO.setMemo(changeFinanceReportEntity.getMemo());
				}
			}
		});
		supplierVO.setFinanceReportList(financeReportLists);

		List<ChangeBrandEntity> brandList = entity.getBrandList();
		Map<Long, BrandVO> brandMap = new HashMap<>();
		List<BrandVO> brandLists = supplierVO.getBrandList();
		brandLists.forEach(brandVO -> brandMap.put(brandVO.getId(), brandVO));
		brandList.forEach(changeBrandEntity -> {
			BrandVO brandVO = brandMap.get(changeBrandEntity.getOriginId());
			if(brandVO == null){
				if(changeBrandEntity.getIsDel() == null || changeBrandEntity.getIsDel() == 0){
					brandVO = BeanMapper.map(changeBrandEntity, BrandVO.class);
					brandVO.setCanInId(supplierVO.getId());
					brandVO.setSupplierName(entity.getName());
					brandVO.setOriginFrom("supplier");
					brandLists.add(brandVO);
				}
			}else {
				if(changeBrandEntity.getIsDel() != null && changeBrandEntity.getIsDel() == 1){
					brandVO.setRowState("del");
				}else {
					brandVO.setBrandName(changeBrandEntity.getBrandName());
					brandVO.setBrandCode(changeBrandEntity.getBrandCode());
					brandVO.setBrandExpirationDate(changeBrandEntity.getBrandExpirationDate());
					brandVO.setAuthorizeExpirationDate(changeBrandEntity.getAuthorizeExpirationDate());
					brandVO.setBrandTypeId(changeBrandEntity.getBrandTypeId());
					brandVO.setBrandTypeName(changeBrandEntity.getBrandTypeName());
				}
			}
		});
		supplierVO.setBrandList(brandLists);

		List<ChangeProductEntity> productionList = entity.getProductionList();
		Map<Long, ProductionVO> productionMap = new HashMap<>();
		List<ProductionVO> productionLists = supplierVO.getProductionList();
		productionLists.forEach(productionVO -> productionMap.put(productionVO.getId(), productionVO));
		productionList.forEach(changeProductEntity -> {
			ProductionVO productionVO = productionMap.get(changeProductEntity.getOriginId());
			if(productionVO == null){
				if(changeProductEntity.getIsDel() == null || changeProductEntity.getIsDel() == 0){
					productionVO = BeanMapper.map(changeProductEntity, ProductionVO.class);
					productionVO.setCanInId(supplierVO.getId());
					/** 根据BrandId 查询出 ChangeBrandEntity ，可能为空，也可能不为空 ，不为空说明是主子孙 */
					ChangeBrandEntity changeBrand = changeBrandService.selectById(changeProductEntity.getBrandId());
					if(changeBrand != null && changeBrand.getOriginId()!=null){
						/** ChangeBrandEntity 不为空 且其OriginId 不为空 则使用其OriginId作为BrandId ，
						 * OriginId 为空则认为 该ChangeBrandEntity是变更时候新增的品牌，原始品牌库不存在，则不必替换产品的BrandId */
						productionVO.setBrandId(changeBrand.getOriginId());
					}
					productionLists.add(productionVO);
				}
			}else {
				if(changeProductEntity.getIsDel() != null && changeProductEntity.getIsDel() == 1){
					productionVO.setRowState("del");
				}else {
					productionVO.setProductName(changeProductEntity.getProductName());
					productionVO.setSupplyMode(changeProductEntity.getSupplyMode());
					productionVO.setPriceRange(changeProductEntity.getPriceRange());
					productionVO.setDeliveryDate(changeProductEntity.getDeliveryDate());
					productionVO.setMemo(changeProductEntity.getMemo());
					productionVO.setBrandName(changeProductEntity.getBrandName());
					productionVO.setBrandCode(changeProductEntity.getBrandCode());
					productionVO.setBrandTypeName(changeProductEntity.getBrandTypeName());
				}
			}
		});
		supplierVO.setProductionList(productionLists);

		List<ChangeFactoryProductEntity> factoryProducts = entity.getFactoryProducts();
		Map<Long, FactoryProductVO> factoryMap = new HashMap<>();
		List<FactoryProductVO> factoryLists = supplierVO.getFactoryProducts();
		factoryLists.forEach(FactoryProductVO -> factoryMap.put(FactoryProductVO.getId(), FactoryProductVO));
		factoryProducts.forEach(changeFactoryEntity -> {
			FactoryProductVO factoryProductVO = factoryMap.get(changeFactoryEntity.getOriginId());
			if(factoryProductVO == null){
				if(changeFactoryEntity.getIsDel() == null || changeFactoryEntity.getIsDel() == 0){
					factoryProductVO = BeanMapper.map(changeFactoryEntity, FactoryProductVO.class);
					factoryProductVO.setPid(supplierVO.getId());
					factoryLists.add(factoryProductVO);
				}
			}else {
				if(changeFactoryEntity.getIsDel() != null && changeFactoryEntity.getIsDel() == 1){
					factoryProductVO.setRowState("del");
				}else {
					factoryProductVO.setFactoryAddress(changeFactoryEntity.getFactoryAddress());
					factoryProductVO.setFactoryArea(changeFactoryEntity.getFactoryArea());
					factoryProductVO.setEquipmentName(changeFactoryEntity.getEquipmentName());
					factoryProductVO.setEquipmentNum(changeFactoryEntity.getEquipmentNum());
					factoryProductVO.setPersonNum(changeFactoryEntity.getPersonNum());
				}
			}
		});
		supplierVO.setFactoryProducts(factoryLists);

		CommonResponse<String> response = iSupplierApi.afterSupplierChangeToSave(supplierVO);
		if(!response.isSuccess()){
			return CommonResponse.error(response.getMsg());
		}
		/** 处理附件 */
		/** 思路  先删除原始 单据所有数据 再将现在的附件数据复制过去 */
		contactList.forEach(certChange -> {
			CertsVO cert =  certsMap.get(certChange.getOriginId());
			if(cert != null){
				if(certChange.getIsDel() == null || certChange.getIsDel() == 0){
					/** 先删除原始 单据所有数据 */
					attachmentApi.deleteFileByParam(cert.getId(), "BT211210000000001", "K1639386256873");
					/** 再复制当前单据的附件到原始单据 */
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(certChange.getId()), "BT211210000000001", "K1639386256873",
							String.valueOf(cert.getId()), "BT211210000000001", "K1639386256873");//证件附件
				}
			}
		});
		financeReportList.forEach(changeFinanceReportEntity -> {
			FinanceReportVO financeReportVO = financeReportMap.get(changeFinanceReportEntity.getOriginId());
			if(financeReportVO != null){
				if(changeFinanceReportEntity.getIsDel() == null || changeFinanceReportEntity.getIsDel() == 0){
					/** 先删除原始 单据所有数据 */
					attachmentApi.deleteFileByParam(financeReportVO.getId(), "BT211210000000001", "caibaofujian");
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeFinanceReportEntity.getId()), "BT211210000000001", "caibaofujian",
							String.valueOf(financeReportVO.getId()), "BT211210000000001", "caibaofujian");//财报附件
				}
			}
		});
		brandList.forEach(changeBrandEntity -> {
			BrandVO brandVO = brandMap.get(changeBrandEntity.getOriginId());
			if(brandVO != null){
				if(changeBrandEntity.getIsDel() == null || changeBrandEntity.getIsDel() == 0){
					/** 先删除原始 单据所有数据 */
					attachmentApi.deleteFileByParam(brandVO.getId(), "BT211210000000001", "pinpailogo");
					attachmentApi.deleteFileByParam(brandVO.getId(), "BT211210000000001", "shangbiaoshu");
					attachmentApi.deleteFileByParam(brandVO.getId(), "BT211210000000001", "shouquanshu");

					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeBrandEntity.getId()), "BT211210000000001", "pinpailogo",
							String.valueOf(brandVO.getId()), "BT211210000000001", "pinpailogo");//品牌logo
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeBrandEntity.getId()), "BT211210000000001", "shangbiaoshu",
							String.valueOf(brandVO.getId()), "BT211210000000001", "shangbiaoshu");//商标证书
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeBrandEntity.getId()), "BT211210000000001", "shouquanshu",
							String.valueOf(brandVO.getId()), "BT211210000000001", "shouquanshu");//授权书

				}
			}
		});
		productionList.forEach(changeProductEntity -> {
			ProductionVO productionVO = productionMap.get(changeProductEntity.getOriginId());
			if(productionVO != null){
				if(changeProductEntity.getIsDel() == null || changeProductEntity.getIsDel() == 0){
					/** 先删除原始 单据所有数据 */
					attachmentApi.deleteFileByParam(productionVO.getId(), "BT211210000000001", "productPicture");
					attachmentApi.deleteFileByParam(productionVO.getId(), "BT211210000000001", "checkReport");
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeProductEntity.getId()), "BT211210000000001", "productPicture",
							String.valueOf(productionVO.getId()), "BT211210000000001", "productPicture");//产品图片
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeProductEntity.getId()), "BT211210000000001", "checkReport",
							String.valueOf(productionVO.getId()), "BT211210000000001", "checkReport");//检测报告
				}
			}
		});
		factoryProducts.forEach(changeFactoryEntity -> {
			FactoryProductVO factoryProductVO = factoryMap.get(changeFactoryEntity.getOriginId());
			if(factoryProductVO != null){
				if(changeFactoryEntity.getIsDel() == null || changeFactoryEntity.getIsDel() == 0){
					/** 先删除原始 单据所有数据 */
					attachmentApi.deleteFileByParam(factoryProductVO.getId(), "BT211210000000001", "personOrg");
					attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(changeFactoryEntity.getId()), "BT211210000000001", "personOrg",
							String.valueOf(factoryProductVO.getId()), "BT211210000000001", "personOrg");//架构
				}
			}
		});


		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "attachMgr");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "K1639384111794");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "K1639384112713");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "K1639384499212");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "K16393844992144");

		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "otherAttrach");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "afterSell");
		attachmentApi.deleteFileByParam(supplierVO.getId(), "BT211210000000001", "peopleConf");

		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "attachMgr",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "attachMgr");//附件
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "K1639384111794",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "K1639384111794");//法人委托授权书
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "K1639384112713",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "K1639384112713");//法人身份复印件
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "K1639384499212",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "K1639384499212");//营业执照
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "K16393844992144",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "K16393844992144");//开户许可证

		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "otherAttrach",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "otherAttrach");//其他资料
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "afterSell",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "afterSell");//售后服务体系
		attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT211210000000001", "peopleConf",
				String.valueOf(supplierVO.getId()), "BT211210000000001", "peopleConf");//人员配备

		entity.setChangState("pass");
		service.saveOrUpdate(entity,false);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("禁止弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("禁止弃审！");
	}

}
