package com.ejianc.business.pro.supplier.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 供应商每个专家考察列表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_pro_supplier_investigate_expert")
public class InvExpertEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="collect_id")
    private Long collectId; // 专家汇总单id
    @TableField(value="can_in_id")
    private Long canInId; // 准入单id
    @TableField(value="can_sub_id")
    private Long canSubId; // 准入单专家列表id
    @TableField(value="code")
    private String code; // 单据编码
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="main_business")
    private String mainBusiness; // 主营类别
    @TableField(value="apply_org_id")
    private Long applyOrgId; // 申请单位id
    @TableField(value="apply_org_name")
    private String applyOrgName; // 申请单位
    @TableField(value="leader")
    private String leader; // 考察组长
    @TableField(value="export_ids")
    private String exportIds; // 考察专家ids
    @TableField(value="export_names")
    private String exportNames; // 考察专家
    @TableField(value="export_id")
    private Long exportId; // 当前考察专家id
    @TableField(value="export_name")
    private String exportName; // 当前考察专家
    @TableField(value="state")
    private String state; // 考察状态：1、待考察，2、已考察，3、已驳回，4、已过期
    @TableField(value="reason")
    private String reason; // 驳回原因
    @TableField(value="submit_date")
    private Date submitDate; // 提交日期
    @TableField(value="start_date")
    private Date startDate; // 考察开始日期
    @TableField(value="inv_date")
    private Date invDate; // 考察日期
    @TableField(value="score")
    private Integer score; // 得分
    @TableField(value="result")
    private String result; // 考察结果：合格  不合格
    @TableField(value="memo")
    private String memo; // 综合评价
    @TableField(value="source_from")
    private String sourceFrom; // 数据来源 supplier  subLeader


    @TableField(exist=false)
    @SubEntity(serviceName="investigateContentService")
    private List<InvestigateContentEntity> investigateContentEntities = new ArrayList<>(); // 供应商考察内容

    public Long getCollectId() {
        return collectId;
    }

    public void setCollectId(Long collectId) {
        this.collectId = collectId;
    }

    public List<InvestigateContentEntity> getInvestigateContentEntities() {
        return investigateContentEntities;
    }

    public String getSourceFrom() {
        return sourceFrom;
    }

    public void setSourceFrom(String sourceFrom) {
        this.sourceFrom = sourceFrom;
    }

    public void setInvestigateContentEntities(List<InvestigateContentEntity> investigateContentEntities) {
        this.investigateContentEntities = investigateContentEntities;
    }

    public String getExportIds() {
        return exportIds;
    }

    public void setExportIds(String exportIds) {
        this.exportIds = exportIds;
    }

    public String getExportNames() {
        return exportNames;
    }

    public void setExportNames(String exportNames) {
        this.exportNames = exportNames;
    }

    public Long getExportId() {
        return exportId;
    }

    public void setExportId(Long exportId) {
        this.exportId = exportId;
    }

    public String getExportName() {
        return exportName;
    }

    public void setExportName(String exportName) {
        this.exportName = exportName;
    }

    public Long getCanInId() {
        return canInId;
    }

    public void setCanInId(Long canInId) {
        this.canInId = canInId;
    }
    public Long getCanSubId() {
        return canSubId;
    }

    public void setCanSubId(Long canSubId) {
        this.canSubId = canSubId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMainBusiness() {
        return mainBusiness;
    }

    public void setMainBusiness(String mainBusiness) {
        this.mainBusiness = mainBusiness;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public String getLeader() {
        return leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }
    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
    public Date getSubmitDate() {
        return submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getInvDate() {
        return invDate;
    }

    public void setInvDate(Date invDate) {
        this.invDate = invDate;
    }
    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }
    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
