package com.ejianc.business.pro.supplier.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.vo.AbnormalVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

@RestController
@RequestMapping("/api/abnormal")
public class AbnormalApi implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    IAbnormalService abnormalService;

    /**
     * @param
     * @Description queryCheckDTO 查询校验对象
     */
    @RequestMapping(value = "/queryAbnormal", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<AbnormalVO>> queryAbnormal() {
        logger.info("获取到请求！");
        QueryWrapper<AbnormalEntity> wrapper = new QueryWrapper<>();
        List<AbnormalEntity> list = abnormalService.list(wrapper);
        List<AbnormalVO> abnormalVOS = BeanMapper.mapList(list, AbnormalVO.class);
        abnormalVOS.forEach(item->{
            item.setLimitBusiness(null);
        });
        logger.info("返回："+JSONObject.toJSONString(abnormalVOS));
        return CommonResponse.success(abnormalVOS);
    }


}
