/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.service.IUpgradeService;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"punish"})
public class PunishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PUNISH-CODE";
    @Autowired
    private IPunishService service;
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private IUpgradeService upgradeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PunishVO> saveOrUpdate(@RequestBody PunishVO saveorUpdateVO) {
        PunishEntity entity = (PunishEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PunishEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse code = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (code.isSuccess()) {
                entity.setCode((String)code.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)saveorUpdateVO.getSupplyId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,2,4,5"));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((PunishEntity)((Object)list.get(0))).getId() != null && !((PunishEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u5904\u7f6e\u5355\uff01");
        }
        List upgradeList = this.upgradeService.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)upgradeList)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u8bc4\u7ea7\u5355\uff01");
        }
        GradeEntity oldGrade = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getOldGrade()));
        GradeEntity gradeEntity = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getGradeId()));
        if (gradeEntity.getWeight() > oldGrade.getWeight()) {
            return CommonResponse.error((String)"\u8bc4\u5b9a\u7b49\u7ea7\u5fc5\u987b\u5c0f\u4e8e\u539f\u7b49\u7ea7\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PunishVO vo = (PunishVO)BeanMapper.map((Object)((Object)entity), PunishVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PunishVO> queryDetail(Long id) {
        PunishEntity entity = (PunishEntity)((Object)this.service.selectById(id));
        PunishVO vo = (PunishVO)BeanMapper.map((Object)((Object)entity), PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PunishVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("supplyTypeNames") != null) {
            param.getParams().put("supplyTypeName", new Parameter("like", ((Parameter)param.getParams().get("supplyTypeNames")).getValue()));
            param.getParams().remove("supplyTypeNames");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("applyDate", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PunishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getFuzzyFields().add("code");
        if (param.getParams().get("supplyTypeNames") != null) {
            param.getParams().put("supplyTypeName", new Parameter("like", ((Parameter)param.getParams().get("supplyTypeNames")).getValue()));
            param.getParams().remove("supplyTypeNames");
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("applyDate", "desc");
        param.setOrderMap(orderMap);
        List list = this.service.queryList(param);
        List records = BeanMapper.mapList((Iterable)list, PunishVO.class);
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            records.forEach(e -> {
                if ("maker".equals(e.getEnterpriseType())) {
                    e.setEnterpriseType("\u5236\u9020\u5546");
                } else {
                    e.setEnterpriseType("\u7ecf\u9500\u5546");
                }
                e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            });
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", records);
        ExcelExport.getInstance().exportWithTrans("Punish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPunishData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> refPunishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PunishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPunshLog"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PunishVO>> queryPunshLog(@RequestParam Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplyId", new Parameter("eq", (Object)supplyId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("applyDate", "desc");
        List page = this.service.queryList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)page, PunishVO.class));
    }

    @RequestMapping(value={"/evaluateHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> history(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }
}

