/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseStrategy;
import com.ejianc.business.pro.supplier.service.appraise.IPushProcessRuleBLogic;
import com.ejianc.business.pro.supplier.service.appraise.YearAppraiseService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.business.pro.supplier.vo.appraise.SupplySubVo;
import com.ejianc.foundation.supplier.api.ISupplierApi;
import com.ejianc.foundation.supplier.vo.SupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rule_b_appraise")
public class RuleBAppraiseStrategy
implements AppraiseStrategy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YearAppraiseService yearAppraiseService;
    @Autowired
    ISupplierApi proSupplierApi;
    @Autowired
    private IProcessService processService;
    @Autowired
    IPushProcessRuleBLogic pushProcessRuleBLogic;
    @Autowired
    private IIncidentService incidentService;

    @Override
    public AppraiseResultVO pushProcessAppraise(AppraiseParamVO appraiseParamVO) {
        this.pushProcessRuleBLogic.logicOne(appraiseParamVO);
        this.pushProcessRuleBLogic.logicTwo(appraiseParamVO);
        AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
        return appraiseResultVO;
    }

    @Override
    public AppraiseResultVO pushYearAppraise(AppraiseParamVO appraiseParamVO) {
        String startDate = this.yearAppraiseService.getStartDate(appraiseParamVO);
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        if (StringUtils.isEmpty((String)startDate)) {
            this.logger.info("\u5f53\u524d\u672a\u5230\u8bbe\u7f6e\u7684\u5468\u671f\u3002");
            return null;
        }
        if (startDate.equals(endDate)) {
            this.logger.info("\u4eca\u65e5\u5df2\u7ecf\u6267\u884c\u8fc7\u63a8\u9001\u3002");
            return null;
        }
        QueryWrapper processWrapper = new QueryWrapper();
        processWrapper.in((Object)"bill_state", new Object[]{1, 3});
        processWrapper.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        processWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processlist = this.processService.list((Wrapper)processWrapper);
        QueryWrapper incidentWrapper = new QueryWrapper();
        incidentWrapper.in((Object)"bill_state", new Object[]{1, 3});
        incidentWrapper.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        incidentWrapper.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentList = this.incidentService.list((Wrapper)incidentWrapper);
        HashSet<Long> supplySet = new HashSet<Long>();
        for (BaseEntity entity : processlist) {
            supplySet.add(entity.getSupplyId());
        }
        for (BaseEntity entity : incidentList) {
            supplySet.add(entity.getSupplyId());
        }
        ArrayList supplyIds = new ArrayList(supplySet);
        this.logger.info("supplyIds:" + supplyIds);
        this.logger.info("processlist:" + JSONObject.toJSONString((Object)processlist));
        this.logger.info("incidentList:" + JSONObject.toJSONString((Object)incidentList));
        if (CollectionUtils.isEmpty(supplyIds)) {
            this.logger.info("\u6ca1\u6709\u751f\u6548\u6001\u7684\u8fc7\u7a0b\u8bc4\u4ef7\u548c\u4e8b\u4ef6\u8bc4\u4ef7\uff0c\u4f9b\u5e94\u5546id\u96c6\u5408\u4e3a\u7a7a\u3002\u65e0\u9700\u63a8\u9001\uff01");
            return null;
        }
        HashMap map = new HashMap();
        map.put("ids", supplyIds);
        CommonResponse shareSupplierList = new CommonResponse();
        String s = JSONObject.toJSONString((Object)shareSupplierList);
        this.logger.info("json:" + s);
        HashMap<Long, SupplierVO> shareSupplierMap = new HashMap<Long, SupplierVO>();
        if (!shareSupplierList.isSuccess() || null == shareSupplierList.getData()) {
            this.logger.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u6570\u636e\u5931\u8d25\u3002");
            return null;
        }
        List vos = BeanMapper.mapList((Iterable)((Iterable)shareSupplierList.getData()), SupplierVO.class);
        for (SupplierVO vo : vos) {
            shareSupplierMap.put(vo.getId(), vo);
        }
        Map<Long, SupplySubVo> longSupplySubVoMap = this.yearAppraiseService.sumSubGrade(processlist, incidentList);
        this.logger.info("shareSupplierMap:" + JSONObject.toJSONString(shareSupplierMap));
        this.logger.info("longSupplySubVoMap:" + JSONObject.toJSONString(longSupplySubVoMap));
        return null;
    }

    @Override
    public String pushIncidentAppraiseAnnually(AppraiseParamVO appraiseParamVO) {
        this.logger.info("\u7b56\u7565B\u5e74\u5ea6\u63a8\u9001\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u672a\u5b9e\u73b0\u3002\u3002\u3002\u3002");
        return "\u7b56\u7565B\u5e74\u5ea6\u63a8\u9001\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u672a\u5b9e\u73b0";
    }
}

