/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupHisPerformanceVO;
import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.service.ISubcontractProcessService;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"evaluateHistory"})
public class EvaluateHistoryController
implements Serializable {
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IPunishService punishService;
    @Autowired
    private ISubcontractProcessService subcontractProcessService;
    @Autowired
    private IContractPoolApi contractPoolApi;

    @RequestMapping(value={"/evaluate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> evaluateHistory(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        ArrayList supHisPerformanceList = new ArrayList();
        CommonResponse commonResponse = this.contractPoolApi.supHisPerformanceList(supplyId);
        if (commonResponse.isSuccess()) {
            for (SupHisPerformanceVO sup : (List)commonResponse.getData()) {
                HistoryVO vo = new HistoryVO();
                vo.setEngineeringName(sup.getEngineeringName());
                vo.setContacts(sup.getContacts());
                vo.setContactsPhone(sup.getContactsPhone());
                vo.setContractMny(sup.getContractMny());
                vo.setCooperationContent(sup.getCooperationContent());
                vo.setEndDay(sup.getEndDay());
                vo.setStartDay(sup.getStartDay());
                vo.setEngineeringAddress(sup.getEngineeringAddress());
                vo.setCooperationOrg(sup.getCooperationOrg());
                vo.setId(Long.valueOf(IdWorker.getId()));
                successList.add(vo);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/history"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EvaluateHistoryVO>> history(Long supplyId) {
        List<EvaluateHistoryVO> list = this.processService.queryHistoryList(supplyId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/subcontractHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EvaluateHistoryVO>> subcontractHistory(Long supplyId, Long headUserId) {
        List<EvaluateHistoryVO> list = this.subcontractProcessService.queryHistoryList(supplyId, headUserId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/subcontractEvaluate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> subcontractEvaluate(String headUserName) {
        QueryParam param = new QueryParam();
        param.getParams().put("head_user_name", new Parameter("eq", (Object)headUserName));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/punish"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierPunish(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)supplyId));
        List list = this.punishService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }

    @RequestMapping(value={"/upgrades"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PunishVO>> supplierUpgrades(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)supplyId));
        List list = this.punishService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }
}

