/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.InviteLinkEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.utils.OuterInterface;
import com.ejianc.business.pro.supplier.vo.InviteVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"noAuth/invite"})
public class InviteNoAuthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBankApi bankApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInviteService service;
    @Autowired
    private OuterInterface outerInterface;
    @Autowired
    private ICanInService iCanInService;
    @Autowired
    private IInviteLinkService iInviteLinkService;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IRoleApi roleApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveorUpdateVO) {
        this.logger.info("\u65e0\u9274\u6743\u65b0\u589e\u6216\u8005\u4fee\u6539:{}", (Object)JSONObject.toJSONString((Object)saveorUpdateVO));
        if (StringUtils.isEmpty((CharSequence)saveorUpdateVO.getTaxpayerNum())) {
            if ("e".equals(saveorUpdateVO.getPersonal())) {
                return CommonResponse.error((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return CommonResponse.error((String)"\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CommonResponse<String> exist = this.service.checkExist(saveorUpdateVO.getId(), saveorUpdateVO.getTaxpayerNum(), saveorUpdateVO.getPersonal(), saveorUpdateVO.getName());
        if (!exist.isSuccess()) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4!");
        }
        InviteEntity entity = (InviteEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, InviteEntity.class));
        if (entity.getId() == null) {
            entity.setCode("S-" + IdWorker.getId());
        }
        entity.setTenantId(999999L);
        this.service.saveOrUpdate((Object)entity, false);
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        entity.setCanInNum("0");
        if (entity.getCheckResult() == 1) {
            entity.setBillState(1);
            SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
            QueryParam params = new QueryParam();
            params.getParams().put("id", new Parameter("in", (Object)saveorUpdateVO.getInviteId()));
            List linkEntityList = this.iInviteLinkService.queryList(params);
            for (Object linkEntity : linkEntityList) {
                supplierVO.setOrgId(((InviteLinkEntity)((Object)linkEntity)).getOrgId());
                supplierVO.setOrgName(((InviteLinkEntity)((Object)linkEntity)).getOrgName());
            }
            supplierVO.setTaxPayerIdentifier(vo.getTaxpayerNum());
            supplierVO.setLegal(vo.getLegalPerson());
            supplierVO.setBusinessScope(vo.getBusinessRange());
            supplierVO.setBlTime(vo.getTimeOut());
            supplierVO.setRegisterTime(vo.getRegisterDate());
            supplierVO.setRegisteredCapital(vo.getRegisterMny());
            supplierVO.setSupplyQueryType(vo.getSupplyQueryType());
            supplierVO.setName(entity.getName());
            if (!entity.getBanks().isEmpty()) {
                ArrayList list = new ArrayList();
                for (BankEntity bank : entity.getBanks()) {
                    BankAccountVO vo1 = (BankAccountVO)BeanMapper.map((Object)((Object)bank), BankAccountVO.class);
                    vo1.setBankAddress(bank.getAddress());
                    vo1.setDefaultFlag(bank.getDefaultable());
                    vo1.setSupplierId(bank.getPid());
                    vo1.setSupplierFlag(Integer.valueOf(1));
                    vo1.setSupplierCode(supplierVO.getCode());
                    vo1.setCategoryId(bank.getCategoryId());
                    vo1.setCategoryName(bank.getCategoryName());
                    vo1.setBankAccount(bank.getBankAccount());
                    if (vo1.getDefaultFlag() == null) {
                        vo1.setDefaultFlag(Integer.valueOf(0));
                    }
                    list.add(vo1);
                }
                supplierVO.setBanks((List)list);
            }
            this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
            this.bankApi.pushToBank(JSONObject.toJSONString((Object)supplierVO).getBytes(StandardCharsets.UTF_8));
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getCheckResult() != 1) {
            ArrayList<Long> roleList = new ArrayList<Long>();
            ArrayList<String> list = new ArrayList<String>();
            roleList.add(586487600554999860L);
            CommonResponse commonResponse = this.roleApi.getRoleUser(roleList, null);
            this.logger.info("data{}", (Object)commonResponse.getCode());
            if (commonResponse.isSuccess()) {
                for (RoleUserRelationVO roleUserRelationVO : (List)commonResponse.getData()) {
                    list.add(roleUserRelationVO.getUserId() + "");
                    this.logger.info("role{}", (Object)roleUserRelationVO.getUserId());
                }
            }
            String url = this.baseHost + "ejc-prosupplier-frontend/#/invitationSupplier/enterpriseCard?id=" + entity.getId();
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
            this.logger.info("list{}", (Object)list.size());
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setReceivers(list.toArray(new String[list.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u4f9b\u5e94\u5546\u51c6\u5165\u6d88\u606f");
            if (saveorUpdateVO.getPersonal().equals("p")) {
                url.replace("enterpriseCard", "personalCard");
            }
            parameter.setContent("\u3010<a href=\"" + url + '\"' + ">" + entity.getName() + "</a>\u3011\u4f9b\u5e94\u5546\uff0c\u4fe1\u606f\u672a\u5ba1\u6838\u901a\u8fc7\uff01\u63d0\u4ea4\u65f6\u95f4\uff1a" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss.SSS", (Date)new Date()) + ",\u8bf7\u53ca\u65f6\u5904\u7406\uff01");
            parameter.setTenantId("999999");
        }
        return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkExist"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkExist(Long id, String taxNum, String personal) {
        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum", new Parameter("eq", (Object)taxNum));
        List list = this.service.queryList(param, false);
        CommonResponse exist = this.iProSupplierApi.judgeTaxpayerNumIsRepeat(taxNum, personal, "-");
        if (!exist.isSuccess()) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5df2\u7ecf\u5728\u4f9b\u5e94\u5546\u5e93\uff0c\u65e0\u9700\u518d\u6b21\u63d0\u4ea4\uff01");
        }
        List canInEntities = this.iCanInService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)canInEntities)) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u6b63\u5728\u8d70\u3010" + ((CanInEntity)((Object)canInEntities.get(0))).getApplyOrgName() + "\u3011\u7684\u3010" + ((CanInEntity)((Object)canInEntities.get(0))).getSupplyTypeName() + "\u3011\u51c6\u5165\u6d41\u7a0b\uff0c\u65e0\u9700\u518d\u6b21\u63d0\u4ea4\uff01");
        }
        if (id == null && ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5728\u9080\u8bf7\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4!");
        }
        if (id != null && ListUtil.isNotEmpty((List)list) && !((InviteEntity)((Object)list.get(0))).getId().equals(id)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5728\u9080\u8bf7\u6d41\u7a0b\u4e2d\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4!");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
        InviteEntity entity = (InviteEntity)((Object)this.service.selectById(id));
        InviteVO vo = (InviteVO)BeanMapper.map((Object)((Object)entity), InviteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InviteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getLicenceOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getLicenceOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getBusinessLicenseInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/getIdCardOcrInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> getIdCardOcrInfo(@RequestParam String imageUrl) {
        return CommonResponse.success((String)"", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)this.outerInterface.getIdCardInfoFromBaidu(imageUrl))));
    }

    @RequestMapping(value={"/checkEnterprise"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkEnterprise(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkEnterpriseFromQcc(name, code));
    }

    @RequestMapping(value={"/checkPerson"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkPerson(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u6210\u529f", (Object)this.outerInterface.checkPersonFromAly(name, code));
    }
}

