/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"limit"})
public class LimitController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ILimitService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LimitVO> saveOrUpdate(@RequestBody LimitVO saveorUpdateVO) {
        List list;
        LimitEntity entity = (LimitEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, LimitEntity.class));
        QueryParam param = new QueryParam();
        param.getParams().put("supplyType", new Parameter("eq", (Object)saveorUpdateVO.getSupplyType()));
        param.getParams().put("contentId", new Parameter("eq", (Object)saveorUpdateVO.getContentId()));
        param.getParams().put("supplyTypeName", new Parameter("eq", (Object)saveorUpdateVO.getSupplyTypeName()));
        if (saveorUpdateVO.getId() != null) {
            param.getParams().put("id", new Parameter("eq", (Object)saveorUpdateVO.getId()));
        }
        if (ListUtil.isNotEmpty((List)(list = this.service.queryList(param))) && ((LimitEntity)((Object)list.get(0))).getId() != null && !((LimitEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u4f9b\u5e94\u5546\u7c7b\u578b\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (CollectionUtil.isNotEmpty((Collection)saveorUpdateVO.getTableWidget())) {
            for (LimitVO vo : saveorUpdateVO.getTableWidget()) {
                LimitEntity en = (LimitEntity)((Object)BeanMapper.map((Object)vo, LimitEntity.class));
                en.setSupplyTypeName(entity.getSupplyTypeName());
                en.setSupplyType(entity.getSupplyType());
                en.setContentId(entity.getContentId());
                en.setContentName(entity.getContentName());
                en.setState(entity.getState());
                this.service.saveOrUpdate((Object)en, false);
            }
        }
        LimitVO vo = (LimitVO)BeanMapper.map((Object)((Object)entity), LimitVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LimitVO> queryDetail(Long id) {
        LimitEntity entity = (LimitEntity)((Object)this.service.selectById(id));
        LimitVO vo = (LimitVO)BeanMapper.map((Object)((Object)entity), LimitVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody Map<String, String> param) {
        String supplyType = param.get("supplyType");
        Long contentId = Long.parseLong(param.get("contentId"));
        this.service.deleteData(supplyType, contentId);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LimitVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LimitVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateState(@RequestBody Map<String, Object> param) {
        String supplyTypeName = (String)param.get("supplyTypeName");
        String supplyType = (String)param.get("supplyType");
        Boolean state = (Boolean)param.get("state");
        this.service.updateState(supplyTypeName, state, supplyType);
        return CommonResponse.success((String)(state != false ? "\u5f00\u542f\u6210\u529f" : "\u5173\u95ed\u6210\u529f"));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Limit-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLimitData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LimitVO>> refLimitData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LimitVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

