/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.PunishEntity;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IHistoryService;
import com.ejianc.business.pro.supplier.service.IPunishService;
import com.ejianc.business.pro.supplier.service.IUpgradeService;
import com.ejianc.business.pro.supplier.vo.HistoryVO;
import com.ejianc.business.pro.supplier.vo.PunishVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"punish"})
public class PunishController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PUNISH-CODE";
    @Autowired
    private IPunishService service;
    @Autowired
    private IHistoryService historyService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private IUpgradeService upgradeService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PunishVO> saveOrUpdate(@RequestBody PunishVO saveorUpdateVO) {
        GradeEntity gradeEntity;
        this.logger.info("\u4f9b\u5e94\u5546\u5904\u7f6e\uff1a{}", (Object)JSONObject.toJSONString((Object)saveorUpdateVO));
        PunishEntity entity = (PunishEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PunishEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse code = this.billCodeApi.getCodeBatchByRuleCode(this.getBillCode(entity), InvocationInfoProxy.getTenantid());
            if (code.isSuccess()) {
                entity.setCode((String)code.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("supplyId", new Parameter("eq", (Object)saveorUpdateVO.getSupplyId()));
        param.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        param.getParams().put("supplyType", new Parameter("eq", (Object)saveorUpdateVO.getSupplyType()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list) && ((PunishEntity)((Object)list.get(0))).getId() != null && !((PunishEntity)((Object)list.get(0))).getId().equals(entity.getId())) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e\uff01");
        }
        QueryParam upgradeParam = new QueryParam();
        upgradeParam.getParams().put("supplyId", new Parameter("eq", (Object)saveorUpdateVO.getSupplyId()));
        upgradeParam.getParams().put("billState", new Parameter("in", (Object)"0,4"));
        upgradeParam.getParams().put("supplyQueryType", new Parameter("eq", (Object)saveorUpdateVO.getSupplyType()));
        List upgradeList = this.upgradeService.queryList(upgradeParam);
        if (CollectionUtils.isNotEmpty((Collection)upgradeList)) {
            return CommonResponse.error((String)"\u8be5\u4f9b\u5e94\u5546\u8bc4\u7ea7\u6709\u6d41\u7a0b\u5c1a\u672a\u5ba1\u6279\u4e0d\u80fd\u6dfb\u52a0\uff01");
        }
        GradeEntity oldGrade = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getOldGrade()));
        if (null != oldGrade && (gradeEntity = (GradeEntity)((Object)this.gradeService.getById(saveorUpdateVO.getGradeId()))).getWeight() > oldGrade.getWeight()) {
            return CommonResponse.error((String)"\u8bc4\u5b9a\u7b49\u7ea7\u5fc5\u987b\u5c0f\u4e8e\u539f\u7b49\u7ea7\uff01");
        }
        this.logger.info("\u4f9b\u5e94\u5546\u5904\u7f6e\u4fdd\u5b58entity\uff1a{}", (Object)JSONObject.toJSONString((Object)saveorUpdateVO));
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u4f9b\u5e94\u5546\u5904\u7f6e\u4fdd\u5b58entity\u4e4b\u540e\uff1a{}", (Object)JSONObject.toJSONString((Object)saveorUpdateVO));
        PunishVO vo = (PunishVO)BeanMapper.map((Object)((Object)entity), PunishVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private String getBillCode(PunishEntity entity) {
        if ("material".equals(entity.getSupplyType())) {
            return "pro-supplier-cz-wz";
        }
        if ("equipment".equals(entity.getSupplyType())) {
            return "pro-supplier-cz-sb";
        }
        if ("other".equals(entity.getSupplyType())) {
            return "pro-supplier-cz-qt";
        }
        return "pro-supplier-cz-wz";
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PunishVO> queryDetail(Long id) {
        PunishEntity entity = (PunishEntity)((Object)this.service.selectById(id));
        PunishVO vo = (PunishVO)BeanMapper.map((Object)((Object)entity), PunishVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PunishVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> queryList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("supplyCode");
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("supplyContent");
        param.getFuzzyFields().add("applyOrg");
        param.getFuzzyFields().add("supplyTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().get("supplyTypeNames") != null) {
            param.getParams().put("supplyTypeName", new Parameter("like", ((Parameter)param.getParams().get("supplyTypeNames")).getValue()));
            param.getParams().remove("supplyTypeNames");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PunishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Punish-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPunishData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PunishVO>> refPunishData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PunishVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/evaluateHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<HistoryVO>> history(Long supplyId) {
        QueryParam param = new QueryParam();
        param.getParams().put("pid", new Parameter("eq", (Object)supplyId));
        List list = this.historyService.queryList(param);
        List successList = BeanMapper.mapList((Iterable)list, HistoryVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)successList);
    }
}

