/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller.appraise;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.service.appraise.AppraiseService;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"appraise"})
public class AppraiseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    AppraiseService appraiseService;
    private static String RULE_CODE = "P-k202Ay57";
    @Autowired
    IParamConfigApi paramConfigApi;

    @PostMapping(value={"/checkAndPushProcessAppraise"})
    public CommonResponse<String> checkAndPushProcessAppraise(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        String curDateStr = sdf.format(new Date());
        if (StringUtils.isEmpty((String)appraiseParamVO.getCheckDate())) {
            this.logger.info("\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u68c0\u6d4b\u4efb\u52a1\uff1a\u5f53\u524d\u672a\u5230\u8bbe\u7f6e\u7684\u5468\u671f\u3002");
            return null;
        }
        if (!curDateStr.equals(appraiseParamVO.getCheckDate())) {
            this.logger.info("\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u68c0\u6d4b\u4efb\u52a1\uff1a\u5f53\u524d\u672a\u975e\u4efb\u52a1\u6267\u884c\u7684\u65e5\u671f\u3002");
            return null;
        }
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        String ruleName = ((ParamRegisterSetVO)byCode.getData()).getValueData();
        this.logger.info("\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u540d\u79f0:{}", (Object)ruleName);
        appraiseParamVO.setRuleName(ruleName);
        boolean rs = this.appraiseService.checkAndPushProcessAppraise(appraiseParamVO);
        if (rs) {
            return CommonResponse.success((String)"\u6267\u884c\u4efb\u52a1\u6210\u529f\uff01");
        }
        return CommonResponse.error((String)"\u6267\u884c\u4efb\u52a1\u5931\u8d25");
    }

    @PostMapping(value={"/pushProcessAppraise"})
    public CommonResponse<AppraiseResultVO> pushProcessAppraise(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        String ruleName = ((ParamRegisterSetVO)byCode.getData()).getValueData();
        this.logger.info("\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u540d\u79f0:{}", (Object)ruleName);
        appraiseParamVO.setRuleName(ruleName);
        AppraiseResultVO appraiseResultVO = this.appraiseService.pushProcessAppraise(appraiseParamVO);
        return CommonResponse.success((Object)appraiseResultVO);
    }

    private AppraiseParamVO getParamVO(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        JSONArray parameters = json.getJSONObject(0).getJSONArray("parameters");
        AppraiseParamVO appraiseParamVO = new AppraiseParamVO();
        block18: for (int i = 0; i < parameters.size(); ++i) {
            String property;
            JSONObject obj = parameters.getJSONObject(i);
            switch (property = (String)obj.get((Object)"property")) {
                case "contractMny": {
                    appraiseParamVO.setContractMny(obj.getBigDecimal("value"));
                    continue block18;
                }
                case "settleContractRatio": {
                    appraiseParamVO.setSettleContractRatio(obj.getBigDecimal("value"));
                    continue block18;
                }
                case "spaceLastDays": {
                    appraiseParamVO.setSpaceLastDays(obj.getInteger("value"));
                    continue block18;
                }
                case "yearPushDate": {
                    appraiseParamVO.setYearPushDate(obj.getString("value"));
                    continue block18;
                }
                case "contractType": {
                    appraiseParamVO.setContractType(obj.getString("value"));
                    continue block18;
                }
                case "subManageFlag": {
                    appraiseParamVO.setSubManageFlag(obj.getString("value"));
                    continue block18;
                }
                case "checkPushDate": {
                    appraiseParamVO.setCheckDate(obj.getString("value"));
                }
            }
        }
        return appraiseParamVO;
    }

    @PostMapping(value={"/pushYearAppraise"})
    public CommonResponse<AppraiseResultVO> pushYearAppraise(HttpServletRequest request) {
        AppraiseParamVO appraiseParamVO = this.getParamVO(request);
        CommonResponse byCode = this.paramConfigApi.getByCode(RULE_CODE);
        if (!byCode.isSuccess()) {
            this.logger.info("\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff0c\u89c4\u5219\u7f16\u7801:{}", (Object)RULE_CODE);
            return CommonResponse.success((String)"\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u8bc4\u4ef7\u89c4\u5219\uff01");
        }
        appraiseParamVO.setRuleName(((ParamRegisterSetVO)byCode.getData()).getValueData());
        AppraiseResultVO appraiseResultVO = this.appraiseService.pushYearAppraise(appraiseParamVO);
        return CommonResponse.success((Object)appraiseResultVO);
    }
}

