/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.service.ICheckSupplierService;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkSupplierService")
public class CheckSupplierServiceImpl
implements ICheckSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    IContractPoolApi contractPoolApi;

    @Override
    public CheckSupplierDTO queryCheckDTO(Long id) {
        CommonResponse supplierDTOCommonResponse = this.proSupplierApi.selectById(id);
        this.logger.info("supplierDTOCommonResponse:" + JSONObject.toJSONString((Object)supplierDTOCommonResponse));
        if (!supplierDTOCommonResponse.isSuccess() || supplierDTOCommonResponse.getData() == null) {
            this.logger.info("\u6839\u636eid\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25\uff01");
            return null;
        }
        SupplierDTO supplierDTO = (SupplierDTO)supplierDTOCommonResponse.getData();
        CheckSupplierDTO checkSupplierDTO = (CheckSupplierDTO)BeanMapper.map((Object)supplierDTO, CheckSupplierDTO.class);
        Long gradeId = checkSupplierDTO.getGradeId();
        String supplyType = checkSupplierDTO.getSupplyType();
        ArrayList<String> types = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)supplyType)) {
            String[] split;
            for (String str : split = supplyType.split(",")) {
                types.add(str);
            }
        }
        this.logger.info("types:" + types);
        if (types.size() > 0) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"gread_id", (Object)gradeId);
            wrapper.in((Object)"supply_type", types);
            List limitList = this.limitService.list((Wrapper)wrapper);
            List limitVOS = BeanMapper.mapList((Iterable)limitList, LimitVO.class);
            checkSupplierDTO.setLimitVOS(limitVOS);
        }
        List certs = checkSupplierDTO.getCerts();
        ArrayList childrenList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)certs)) {
            ArrayList certIds = new ArrayList();
            for (CertsDTO dto : certs) {
                QueryWrapper queryChildrenWrapper = new QueryWrapper();
                queryChildrenWrapper.like((Object)"superior_id", (Object)dto.getCertId());
                List list = this.certificateService.list((Wrapper)queryChildrenWrapper);
                childrenList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty(childrenList)) {
                for (CertificateEntity certificateEntity : childrenList) {
                    CertsDTO certsDTO = new CertsDTO();
                    certsDTO.setCertId(certificateEntity.getId());
                    certsDTO.setCertName(certificateEntity.getName());
                    certs.add(certsDTO);
                }
            }
            checkSupplierDTO.setCerts(certs);
        }
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(id);
        String startDate = DateUtil.getYear() + "-01-01";
        String endDate = DateUtil.getYear() + "-12-31";
        SupplyVO supplyVO = new SupplyVO();
        supplyVO.setSupplierIds(supplierIds);
        supplyVO.setStartDate(startDate);
        supplyVO.setEndDate(endDate);
        this.logger.info("supplyVO:" + JSONObject.toJSONString((Object)supplyVO));
        CommonResponse contractList = this.contractPoolApi.getContractList(supplyVO);
        this.logger.info("contractList:" + JSONObject.toJSONString((Object)contractList));
        if (!contractList.isSuccess() || contractList.getData() == null) {
            this.logger.info("\u67e5\u8be2\u5408\u540c\u6c60\u6570\u636e\u5931\u8d25\uff01");
            return null;
        }
        ArrayList<ContractDTO> contractListS = new ArrayList<ContractDTO>();
        for (Object object : (JSONArray)contractList.getData()) {
            String str = JSONObject.toJSONString(object);
            this.logger.info("str:" + str);
            ContractDTO dto = (ContractDTO)JSONObject.parseObject((String)str, ContractDTO.class);
            this.logger.info("dto:" + JSONObject.toJSONString((Object)dto));
            contractListS.add(dto);
        }
        BigDecimal sumMny = BigDecimal.ZERO;
        for (ContractDTO dto : contractListS) {
            sumMny = sumMny.add(dto.getContractTaxMny());
        }
        checkSupplierDTO.setContractDTOS(contractListS);
        checkSupplierDTO.setSumContractMny(sumMny);
        this.logger.info("checkSupplierDTO:" + JSONObject.toJSONString((Object)checkSupplierDTO));
        return checkSupplierDTO;
    }
}

