/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteLinkService;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.foundation.share.api.IBankApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invite")
public class InviteBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IInviteService service;
    @Autowired
    private IInviteLinkService iInviteLinkService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankApi bankApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        InviteEntity vo = (InviteEntity)((Object)this.service.selectById(billId));
        return this.service.checkExist(billId, vo.getTaxpayerNum(), vo.getPersonal(), vo.getName());
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InviteEntity vo = (InviteEntity)((Object)this.service.selectById(billId));
        SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)vo), SupplierVO.class);
        supplierVO.setTaxPayerIdentifier(vo.getTaxpayerNum());
        supplierVO.setLegal(vo.getLegalPerson());
        supplierVO.setBusinessScope(vo.getBusinessRange());
        supplierVO.setBlTime(vo.getTimeOut());
        supplierVO.setRegisterTime(vo.getRegisterDate());
        supplierVO.setRegisteredCapital(vo.getRegisterMny());
        supplierVO.setSupplyQueryType(vo.getSupplyQueryType());
        supplierVO.setName(vo.getName());
        if (!vo.getBanks().isEmpty()) {
            ArrayList<BankAccountVO> list = new ArrayList<BankAccountVO>();
            for (BankEntity bank : vo.getBanks()) {
                BankAccountVO vo1 = (BankAccountVO)BeanMapper.map((Object)((Object)bank), BankAccountVO.class);
                vo1.setDefaultFlag(bank.getDefaultable());
                vo1.setBankAddress(bank.getAddress());
                vo1.setSupplierId(bank.getPid());
                vo1.setSupplierFlag(Integer.valueOf(1));
                vo1.setSupplierCode(supplierVO.getCode());
                vo1.setCategoryId(bank.getCategoryId());
                vo1.setCategoryName(bank.getCategoryName());
                vo1.setBankAccount(bank.getBankAccount());
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        vo.setCheckResult(1);
        this.service.saveOrUpdate((Object)vo, false);
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        this.bankApi.pushToBank(JSONObject.toJSONString((Object)supplierVO).getBytes(StandardCharsets.UTF_8));
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u76ee\u524d\u4e0d\u652f\u6301\u5f03\u5ba1\u64a4\u56de\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

