/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.bean.SubleaderCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubleaderCanInSubEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInService;
import com.ejianc.business.pro.supplier.vo.SubleaderCanInVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subleaderCanIn"})
public class SubleaderCanInController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubleaderCanInService service;
    @Autowired
    private IInviteService iInviteService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubleaderCanInVO> saveOrUpdate(@RequestBody SubleaderCanInVO saveOrUpdateVO) {
        SubleaderCanInEntity entity = (SubleaderCanInEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SubleaderCanInEntity.class));
        if (saveOrUpdateVO.getIvtId() != null && entity.getId() == null) {
            Object inviteEntity = (InviteEntity)((Object)this.iInviteService.selectById(saveOrUpdateVO.getIvtId()));
            if (inviteEntity == null) {
                return CommonResponse.error((String)"\u9080\u8bf7\u5355\u636e\u4e0d\u5b58\u5728\uff01");
            }
            if (((InviteEntity)((Object)inviteEntity)).getBillState() != 0) {
                return CommonResponse.error((String)"\u9080\u8bf7\u5355\u636e\u5df2\u5904\u7406\uff0c\u4e0d\u53ef\u518d\u6b21\u51c6\u5165\uff01");
            }
            ((InviteEntity)((Object)inviteEntity)).setBillState(1);
            ((InviteEntity)((Object)inviteEntity)).setHandleTime(new Date());
            this.iInviteService.saveOrUpdateNoES(inviteEntity);
        }
        if (ListUtil.isNotEmpty(entity.getSubleaderCanInSubEntities())) {
            for (SubleaderCanInSubEntity subEntity : entity.getSubleaderCanInSubEntities()) {
                CommonResponse response = this.iProSupplierApi.checkSubLeaderIsExist(entity.getSupplyId(), subEntity.getIdNum());
                if (response.isSuccess() && !((Boolean)response.getData()).booleanValue()) continue;
                this.logger.info("\u6821\u9a8c\u5206\u5305\u8d1f\u8d23\u4eba\u662f\u5426\u5b58\u5728\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
                return CommonResponse.error((String)response.getMsg());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SubleaderCanInVO vo = (SubleaderCanInVO)BeanMapper.map((Object)((Object)entity), SubleaderCanInVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubleaderCanInVO> queryDetail(Long id) {
        SubleaderCanInEntity entity = (SubleaderCanInEntity)((Object)this.service.selectById(id));
        SubleaderCanInVO vo = (SubleaderCanInVO)BeanMapper.map((Object)((Object)entity), SubleaderCanInVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubleaderCanInVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubleaderCanInVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("supplyName");
        fuzzyFields.add("supplyTaxNum");
        fuzzyFields.add("applyPerson");
        fuzzyFields.add("orgName");
        fuzzyFields.add("subLeaders");
        fuzzyFields.add("areaName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubleaderCanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubleaderCanIn-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubleaderCanInData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubleaderCanInVO>> refSubleaderCanInData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubleaderCanInVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

