/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.pro.supplier.bean.AbnormalEntity;
import com.ejianc.business.pro.supplier.bean.BankEntity;
import com.ejianc.business.pro.supplier.bean.CertsEntity;
import com.ejianc.business.pro.supplier.bean.SubcontractCanInEntity;
import com.ejianc.business.pro.supplier.bean.SubleadersEntity;
import com.ejianc.business.pro.supplier.mapper.SubcontractCanInMapper;
import com.ejianc.business.pro.supplier.service.IAbnormalService;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.service.impl.PunishBpmServiceImpl;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subcontractCanInService")
public class SubcontractCanInServiceImpl
extends BaseServiceImpl<SubcontractCanInMapper, SubcontractCanInEntity>
implements ISubcontractCanInService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAbnormalService abnormalService;

    @Override
    public CommonResponse<String> pushSupplierToShare(SubcontractCanInEntity entity, String billTypeCode) {
        Long billId = entity.getId();
        SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)entity), SupplierVO.class);
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());
        supplierVO.setLegal(entity.getLegalPerson());
        supplierVO.setBusinessScope(entity.getBusinessRange());
        supplierVO.setBlTime(entity.getTimeOut());
        supplierVO.setTenantUserName(entity.getCoordinationName());
        supplierVO.setTenantPhone(entity.getCoordinationPhone());
        supplierVO.setRegisterTime(entity.getRegisterDate());
        supplierVO.setRegisteredCapital(entity.getRegisterMny());
        if (!entity.getBanks().isEmpty()) {
            ArrayList<BankAccountVO> list = new ArrayList<BankAccountVO>();
            for (BankEntity bank : entity.getBanks()) {
                BankAccountVO vo1 = (BankAccountVO)BeanMapper.map((Object)((Object)bank), BankAccountVO.class);
                vo1.setBankAddress(bank.getAddress());
                list.add(vo1);
            }
            supplierVO.setBanks(list);
        }
        supplierVO.setAccessId(billId);
        if (entity.getInException() != null && entity.getInException().booleanValue()) {
            supplierVO.setInException(entity.getInException());
            AbnormalEntity abnormalEntity = (AbnormalEntity)((Object)this.abnormalService.getById(entity.getPunishType()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (abnormalEntity.getLastTime() != null) {
                    String exceptionEndDate = PunishBpmServiceImpl.getLastMonthDate(new Date(), abnormalEntity.getLastTime());
                    Date date = simpleDateFormat.parse(exceptionEndDate);
                    supplierVO.setExceptionEndDate(date);
                } else {
                    Date date = simpleDateFormat.parse("3000-01-01");
                    supplierVO.setExceptionEndDate(date);
                }
                supplierVO.setPunishApplyOrg(entity.getApplyOrgName());
                supplierVO.setPunishDate(new Date());
                supplierVO.setPunishGrade(entity.getGradeName());
                supplierVO.setPunishMemo("\u51c6\u5165\u65f6\u76f4\u63a5\u62c9\u9ed1\uff01");
                supplierVO.setPunishType(entity.getPunishType());
            }
            catch (Exception e) {
                this.logger.info("\u51c6\u5165\u65f6\u5019 \u76f4\u63a5\u62c9\u9ed1\u51fa\u9519---{},----billId : {}", (Object)e.getMessage(), (Object)billId);
            }
        }
        this.logger.info("billTypeCode---{}", (Object)billTypeCode);
        billTypeCode = "BT211230000000004";
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "attachMgr", String.valueOf(billId), "BT200422000000028", "attachMgr");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384111794", String.valueOf(billId), "BT200422000000028", "K1639384111794");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384112713", String.valueOf(billId), "BT200422000000028", "K1639384112713");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384499212", String.valueOf(billId), "BT200422000000028", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384662753", String.valueOf(billId), "BT200422000000028", "K1639384662753");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K1639384663721", String.valueOf(billId), "BT200422000000028", "K1639384663721");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), billTypeCode, "K16393844992144", String.valueOf(billId), "BT200422000000028", "K16393844992144");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        if (ListUtil.isNotEmpty(entity.getCerts())) {
            for (CertsEntity cert : entity.getCerts()) {
                this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(cert.getId()), billTypeCode, "K1639386256873", String.valueOf(cert.getId()), "BT200422000000028", "K1639386256873");
            }
        }
        if (ListUtil.isNotEmpty(entity.getSubLeaders())) {
            CommonResponse copyRs = null;
            for (SubleadersEntity subLeader : entity.getSubLeaders()) {
                copyRs = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "K1639443798330", String.valueOf(subLeader.getId()), "BT200422000000028", "K1639443798330");
                this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba-{}, \u793e\u4fdd\u8bc1\u660e\u540c\u6b65\u4f9b\u5e94\u5546\u5e93\u7ed3\u679c\uff1a{}", (Object)subLeader.getId(), (Object)JSONObject.toJSONString((Object)copyRs));
                copyRs = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(subLeader.getId()), billTypeCode, "labsubContractFile", String.valueOf(subLeader.getId()), "BT200422000000028", "labsubContractFile");
                this.logger.info("\u5206\u5305\u8d1f\u8d23\u4eba-{}, \u52b3\u52a8\u5408\u540c\u540c\u6b65\u4f9b\u5e94\u5546\u5e93\u7ed3\u679c\uff1a{}", (Object)subLeader.getId(), (Object)JSONObject.toJSONString((Object)copyRs));
            }
        }
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        return this.iProSupplierApi.pushSupplierToShare(JSONObject.toJSONString((Object)supplierVO).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public CommonResponse<String> afterInvestigate(Long canInId, Long gradeId, String gradeName) {
        SubcontractCanInEntity canInEntity = (SubcontractCanInEntity)((Object)this.selectById(canInId));
        canInEntity.setGradeId(gradeId);
        canInEntity.setGradeName(gradeName);
        return this.pushSupplierToShare(canInEntity, "BT211230000000004");
    }
}

