package com.ejianc.business.pro.supplier.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.SupplierQueryType;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pro.supplier.bean.InviteEntity;
import com.ejianc.business.pro.supplier.service.IInviteService;
import com.ejianc.business.pro.supplier.vo.InviteVO;

/**
 * 供应商准入邀请表
 *
 * @author generator
 */
@Controller
@RequestMapping("invite")
public class InviteController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IInviteService service;


    @Autowired
    private ICanInService iCanInService;


    @Autowired
    private IProSupplierApi iProSupplierApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdate(@RequestBody InviteVO saveOrUpdateVO) {
        InviteEntity entity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if(entity.getSupplyType().contains("material") || entity.getSupplyType().contains("equipment")){
                entity.setSupplyQueryType(SupplierQueryType.materialEquipment);
            }else if(entity.getSupplyType().contains("labor") || entity.getSupplyType().contains("major")){
                entity.setSupplyQueryType(SupplierQueryType.laborSub);
            }else {
                entity.setSupplyQueryType("other");
            }
        }

        service.saveOrUpdate(entity, false);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description saveOrUpdate 无鉴权新增或者修改1
     */
    @RequestMapping(value = "/noAuth/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InviteVO> saveOrUpdateNoAuth(@RequestBody InviteVO saveOrUpdateVO) {
        logger.info("无鉴权新增或者修改:{}",JSONObject.toJSONString(saveOrUpdateVO));
        if(StringUtils.isEmpty(saveOrUpdateVO.getTaxpayerNum())){
            if("e".equals(saveOrUpdateVO.getPersonal())){
                return CommonResponse.error("纳税人识别号不能为空");
            }
            return CommonResponse.error("身份证号不能为空");
        }
        /** 校验供应商库 */
        CommonResponse<String> exist = iProSupplierApi.judgeTaxpayerNumIsRepeat(saveOrUpdateVO.getTaxpayerNum(), saveOrUpdateVO.getPersonal(),"-");
        logger.info("校验供应商库"+JSONObject.toJSONString(exist));
        if(!exist.isSuccess()){
            return CommonResponse.error("该供应商已经是【"+exist.getData()+"】，无需再次提交!");
        }

        QueryParam param = new QueryParam();
        param.getParams().put("taxpayerNum",new Parameter(QueryParam.EQ,saveOrUpdateVO.getTaxpayerNum()));

        /** 校验准入表 */
        List<CanInEntity> canInEntities = iCanInService.queryList(param,false);
        if(ListUtil.isNotEmpty(canInEntities)){
            return CommonResponse.error("该供应商正在走【"+canInEntities.get(0).getApplyOrgName()+"】的【"+canInEntities.get(0).getSupplyTypeName()+"】准入流程，无需再次提交!");
        }
        /** 校验邀请表 */
        param.getParams().put("billState",new Parameter(QueryParam.IN,"0,1"));
        List<InviteEntity> list = service.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("该供应商在【"+list.get(0).getSupplyTypeName()+"】邀请中存在，无需重复提交!");
        }
        InviteEntity entity = BeanMapper.map(saveOrUpdateVO, InviteEntity.class);
        if(entity.getId() == null){
            entity.setCode("S-"+ IdWorker.getId());
        }
        entity.setTenantId(999999L);
        if(entity.getSupplyType().toLowerCase().contains("material") || entity.getSupplyType().contains("equipment")){
            entity.setSupplyQueryType(SupplierQueryType.materialEquipment);
        }else if(entity.getSupplyType().contains("labor") || entity.getSupplyType().contains("major")|| entity.getSupplyType().contains("sub")){
            entity.setSupplyQueryType(SupplierQueryType.laborSub);
        }else {
            entity.setSupplyQueryType("other");
        }
        service.saveOrUpdate(entity, false);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("提交成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> queryDetail(Long id) {
        InviteEntity entity = service.selectById(id);
        InviteVO vo = BeanMapper.map(entity, InviteVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InviteVO> vos) {
        service.removeByIds(vos.stream().map(InviteVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询待准入列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");

        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("billState", new Parameter(QueryParam.EQ, "0"));

        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description queryHandleList 查询已处理列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryHandleList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> queryHandleList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("taxpayer_num");
        param.getFuzzyFields().add("area_name");

        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("applyOrgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,2"));

        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InviteEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Invite-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refInviteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InviteVO>> refInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<InviteEntity> page = service.queryPage(param, false);
        IPage<InviteVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InviteVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @Description ignoreData 忽略供应商
     */
    @RequestMapping(value = "/ignoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InviteVO> ignoreData(Long id,Long userId,String userName) {
        InviteEntity entity = service.selectById(id);
        InviteVO inviteVO = BeanMapper.map(entity, InviteVO.class);
        inviteVO.setBillState(2);
        inviteVO.setHandlePerson(userName);
        inviteVO.setHandlePersonId(userId);
        inviteVO.setHandleTime(new Date());
        CommonResponse<InviteVO> inviteVOCommonResponse = saveOrUpdate(inviteVO);
        if (inviteVOCommonResponse.isSuccess()) {
            return CommonResponse.success("忽略成功！",inviteVOCommonResponse.getData());
        } else {
            return CommonResponse.error("忽略失败！");
        }
    }

    /**
     * @param ids
     * @Description ignoreDatas 批量忽略供应商
     */
    @RequestMapping(value = "/ignoreDatas", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> ignoreDatas(@RequestBody String data) {
        QueryParam param = new QueryParam();
        JSONObject json = JSONObject.parseObject(data);
        JSONArray jsonArray = json.getJSONArray("ids");
        List<Long> ids = JSONObject.parseArray(jsonArray.toJSONString(), Long.class);

        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<InviteEntity> inviteEntities = service.queryList(param);
        for (InviteEntity VO : inviteEntities) {
            VO.setBillState(2);
            VO.setHandleTime(new Date());
            VO.setHandlePerson(json.getString("userName"));
            VO.setHandlePersonId(json.getLong("userId"));
        }
        boolean b = service.saveOrUpdateBatch(inviteEntities);
        if (b) {
            return CommonResponse.success("忽略成功！");
        } else {
            return CommonResponse.error("忽略失败！");
        }
    }
}
