package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.SubleaderCanInSubEntity;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SubleadersPushVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.SubleaderCanInMapper;
import com.ejianc.business.pro.supplier.bean.SubleaderCanInEntity;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInService;

import java.util.ArrayList;
import java.util.List;

/**
 * 分包供应商分包负责人准入
 * 
 * @author generator
 * 
 */
@Service("subleaderCanInService")
public class SubleaderCanInServiceImpl extends BaseServiceImpl<SubleaderCanInMapper, SubleaderCanInEntity> implements ISubleaderCanInService{

    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Override
    public CommonResponse<String> pushSupplierToShare(Long id) {
        SubleaderCanInEntity entity = selectById(id);
        SubleadersPushVO pushVO = new SubleadersPushVO();
        pushVO.setSupplierId(entity.getSupplyId());
        List<SubleadersVO> allList = new ArrayList<>();
        for(SubleaderCanInSubEntity subEntity :entity.getSubleaderCanInSubEntities()){
            SubleadersVO subleadersVO = new SubleadersVO();
            subleadersVO.setName(subEntity.getName());
            subleadersVO.setIdNum(subEntity.getIdNum());
            subleadersVO.setPhone(subEntity.getPhone());
            subleadersVO.setGrade(subEntity.getGrade());
            subleadersVO.setGradeName(subEntity.getGradeName());
            subleadersVO.setId(subEntity.getId());
            subleadersVO.setContentIdForTrans(subEntity.getContentId());
            allList.add(subleadersVO);
        }

        pushVO.setSubLeaders(allList);
        return iProSupplierApi.pushSubLeadersToShare(pushVO);
    }
}
