/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.appraise.PushProcessLogic;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.IncidentVO;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushProcessLogic")
public class PushProcessRuleALogic
implements PushProcessLogic {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "INCIDENT";
    @Autowired
    private SessionManager sessionManager;

    @Override
    public List<IncidentVO> logicOne(AppraiseParamVO appraiseParamVO) {
        CommonResponse listCommonResponse;
        ArrayList<ContractPoolVO> pushProcessList = new ArrayList<ContractPoolVO>();
        List<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty((CharSequence)contractType)) {
            ArrayList<String> contractTypeList = new ArrayList<String>();
            if ("materialEquipment".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            } else if ("sub".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            } else if ("other".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter("in", contractTypeList));
        }
        if ((listCommonResponse = this.contractPoolApi.queryList(queryParam)).isSuccess()) {
            List contractPoolVOList = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)contractPoolVOList)) {
                BigDecimal contractMny = appraiseParamVO.getContractMny();
                BigDecimal setContractMny = ComputeUtil.safeMultiply((BigDecimal)contractMny, (BigDecimal)new BigDecimal(10000));
                List contractList = contractPoolVOList.stream().filter(s -> s.getContractTaxMny() != null).filter(s -> s.getContractTaxMny().compareTo(setContractMny) != -1).collect(Collectors.toList());
                Map<Long, ContractPoolVO> contractPoolMap = contractList.stream().collect(Collectors.toMap(k -> k.getId(), k -> k));
                if (CollectionUtils.isNotEmpty(contractList)) {
                    List settlePoolList;
                    List contractIds = contractList.stream().map(BaseVO::getId).collect(Collectors.toList());
                    QueryParam settleQueryParam = new QueryParam();
                    settleQueryParam.getParams().put("contractId", new Parameter("in", contractIds));
                    CommonResponse settleCommonResponse = this.settlePoolApi.queryList(settleQueryParam);
                    if (settleCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(settlePoolList = (List)settleCommonResponse.getData()))) {
                        Map<Long, BigDecimal> settlePoolMap = settlePoolList.stream().filter(s -> s.getContractId() != null).collect(Collectors.groupingBy(SettlePoolVO::getContractId, Collectors.reducing(BigDecimal.ZERO, SettlePoolVO::getCurTaxMny, BigDecimal::add)));
                        Set<Long> contractIdSet = settlePoolMap.keySet();
                        for (Long contractId : contractIdSet) {
                            BigDecimal settleContractRatio;
                            BigDecimal settleContractMny;
                            BigDecimal contractTaxMny = contractPoolMap.get(contractId).getContractTaxMny();
                            BigDecimal settleTaxMny = settlePoolMap.get(contractId);
                            if (settleTaxMny.compareTo(settleContractMny = ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)(settleContractRatio = ComputeUtil.safeDiv((BigDecimal)appraiseParamVO.getSettleContractRatio(), (BigDecimal)new BigDecimal(100))))) == -1) continue;
                            pushProcessList.add(contractPoolMap.get(contractId));
                        }
                        List pushProcessContractIds = pushProcessList.stream().map(BaseVO::getId).collect(Collectors.toList());
                        this.logger.info("\u6ee1\u8db3\u8c03\u5ea6\u53c2\u6570\u5408\u540cId\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString(pushProcessContractIds));
                        if (CollectionUtils.isEmpty(pushProcessContractIds)) {
                            return null;
                        }
                        QueryParam queryIncidentParam = new QueryParam();
                        queryIncidentParam.getParams().put("contractId", new Parameter("in", pushProcessContractIds));
                        queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
                        List incidentEntities = this.incidentService.queryList(queryIncidentParam, false);
                        this.logger.info("\u6839\u636e\u5408\u540cId\u67e5\u8be2\u51fa\u5408\u540c\u5bf9\u5e94\u8fc7\u7a0b\u8bc4\u4ef7\u6570\u91cf\uff1a", (Object)incidentEntities.size());
                        if (incidentEntities.size() == pushProcessContractIds.size()) {
                            return null;
                        }
                        PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
                        if (incidentEntities.size() == 0) {
                            processList = pushProcessRuleALogic.getProcessList(pushProcessList, null, this.userApi, this.billCodeApi, this.sessionManager);
                            return processList;
                        }
                        Map<Long, List<IncidentEntity>> map = incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
                        processList = pushProcessRuleALogic.getProcessList(pushProcessList, map, this.userApi, this.billCodeApi, this.sessionManager);
                        return processList;
                    }
                }
            }
        } else {
            this.logger.error("\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u903b\u8f91\u4e00\uff1a\u67e5\u8be2\u5408\u540c\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)listCommonResponse));
        }
        return processList;
    }

    @Override
    public List<IncidentVO> logicTwo(AppraiseParamVO appraiseParamVO) {
        List contractPoolVOList;
        CommonResponse listCommonResponse;
        List<IncidentVO> processList = new ArrayList<IncidentVO>();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
        String contractType = appraiseParamVO.getContractType();
        if (StringUtils.isNotEmpty((CharSequence)contractType)) {
            ArrayList<String> contractTypeList = new ArrayList<String>();
            if ("materialEquipment".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u5468\u8f6c\u6750\u5408\u540c.getTypeCode());
            } else if ("sub".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode());
                contractTypeList.add(ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode());
            } else if ("other".equals(contractType)) {
                contractTypeList.add(ContractTypeEnum.\u5176\u4ed6\u652f\u51fa.getTypeCode());
            }
            queryParam.getParams().put("sourceType", new Parameter("in", contractTypeList));
        }
        if ((listCommonResponse = this.contractPoolApi.queryList(queryParam)).isSuccess() && CollectionUtils.isNotEmpty((Collection)(contractPoolVOList = (List)listCommonResponse.getData()))) {
            List contractPoolIds = contractPoolVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryParam queryIncidentParam = new QueryParam();
            queryIncidentParam.getParams().put("contractId", new Parameter("in", contractPoolIds));
            queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
            List incidentEntities = this.incidentService.queryList(queryIncidentParam, false);
            PushProcessRuleALogic pushProcessRuleALogic = new PushProcessRuleALogic();
            if (incidentEntities.size() == 0) {
                processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, null, this.userApi, this.billCodeApi, this.sessionManager);
                return processList;
            }
            Map<Long, List<IncidentEntity>> map = incidentEntities.stream().collect(Collectors.groupingBy(IncidentEntity::getContractId));
            processList = pushProcessRuleALogic.getProcessList(contractPoolVOList, map, this.userApi, this.billCodeApi, this.sessionManager);
            return processList;
        }
        return processList;
    }

    @Override
    public List<IncidentVO> getAnnualIncidentPushList(AppraiseParamVO appraiseParamVO, String startDate) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("in", (Object)new String[]{ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode(), ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode()}));
        queryParam.getParams().put("contractProperty", new Parameter("eq", (Object)0));
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (!listCommonResponse.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5c65\u7ea6\u4e2d\u3001\u5df2\u51bb\u7ed3\u7684\u652f\u51fa\u5408\u540c\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)listCommonResponse));
            throw new BusinessException("\u83b7\u53d6\u5c65\u7ea6\u4e2d\u3001\u5df2\u51bb\u7ed3\u7684\u652f\u51fa\u5408\u540c\u5217\u8868\u5931\u8d25\uff01");
        }
        List contractList = (List)listCommonResponse.getData();
        if (CollectionUtils.isEmpty((Collection)contractList)) {
            this.logger.error("\u83b7\u53d6\u5c65\u7ea6\u4e2d\u3001\u5df2\u51bb\u7ed3\u7684\u652f\u51fa\u5408\u540c\u5217\u8868\u4e3a\u7a7a");
            return null;
        }
        List pushProcessContractIds = contractList.stream().map(BaseVO::getId).collect(Collectors.toList());
        String endDate = DateUtil.getYear() + "-" + appraiseParamVO.getYearPushDate();
        QueryWrapper incidentQuery = new QueryWrapper();
        incidentQuery.select(new String[]{"distinct(contract_id)"});
        incidentQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        incidentQuery.in((Object)"contract_id", pushProcessContractIds);
        incidentQuery.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        incidentQuery.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List incidentIds = this.incidentService.listObjs((Wrapper)incidentQuery, item -> Long.valueOf(item.toString()));
        if (CollectionUtils.isNotEmpty((Collection)incidentIds)) {
            pushProcessContractIds.removeAll(incidentIds);
        }
        if (CollectionUtils.isEmpty(pushProcessContractIds)) {
            this.logger.info("\u6392\u9664\u6389\u5df2\u5b58\u5728\u8fc7\u7a0b\u8bc4\u4ef7\u7684\u5408\u540c,\u53ef\u63a8\u9001\u8fc7\u7a0b\u8bc4\u4ef7\u5408\u540c\u5217\u8868\u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u5e74\u5ea6\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return null;
        }
        QueryWrapper processQuery = new QueryWrapper();
        processQuery.select(new String[]{"distinct(contract_id)"});
        processQuery.in((Object)"contract_id", pushProcessContractIds);
        processQuery.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        processQuery.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        processQuery.ge((Object)"date_format(create_time,'%Y-%m-%d')", (Object)startDate);
        processQuery.le((Object)"date_format(create_time,'%Y-%m-%d')", (Object)endDate);
        List processIds = this.incidentService.listObjs((Wrapper)incidentQuery, item -> Long.valueOf(item.toString()));
        if (CollectionUtils.isNotEmpty((Collection)processIds)) {
            pushProcessContractIds.removeAll(processIds);
        }
        if (CollectionUtils.isEmpty(pushProcessContractIds)) {
            this.logger.info("\u6392\u9664\u6389\u5df2\u5b58\u5728\u751f\u6548\u4e8b\u4ef6\u8bc4\u4ef7\u7684\u5408\u540c,\u53ef\u63a8\u9001\u8fc7\u7a0b\u8bc4\u4ef7\u5408\u540c\u5217\u8868\u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u8fc7\u7a0b\u8bc4\u4ef7\u5e74\u5ea6\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\u3002\u3002\u3002\u3002");
            return null;
        }
        return this.getAnnualIncidentList(contractList.stream().filter(item -> pushProcessContractIds.contains(item.getId())).collect(Collectors.toList()));
    }

    private List<IncidentVO> getAnnualIncidentList(List<ContractPoolVO> contractList) {
        ArrayList<IncidentVO> list = new ArrayList<IncidentVO>();
        IncidentVO incidentVO = null;
        CommonResponse billCodes = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), contractList.size());
        if (!billCodes.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List billCodeList = (List)billCodes.getData();
        int billCodeIdx = 0;
        for (ContractPoolVO e : contractList) {
            incidentVO = new IncidentVO();
            incidentVO.setCode((String)billCodeList.get(billCodeIdx));
            incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
            incidentVO.setPerformanceStatus(e.getPerformanceStatus());
            incidentVO.setStatus(Integer.valueOf(0));
            incidentVO.setContractType(e.getSourceType());
            ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode((String)e.getSourceType());
            if (contractTypeEnum != null) {
                String contractTypeName = ContractTypeEnum.getByCode((String)e.getSourceType()).getTypeName();
                incidentVO.setContractTypeName(contractTypeName);
            }
            incidentVO.setContractName(e.getContractName());
            incidentVO.setContractCode(e.getContractCode());
            incidentVO.setProjectId(e.getProjectId());
            incidentVO.setProjectName(e.getProjectName());
            incidentVO.setContractAmount(e.getContractTaxMny());
            incidentVO.setSupplyId(e.getPartybId());
            incidentVO.setSupplyName(e.getPartybName());
            String supplyQueryType = SupplyQueryTypeUtil.get((String)"RULE_A", (String)e.getSourceType());
            incidentVO.setSupplyQueryType(supplyQueryType);
            incidentVO.setOrgId(e.getOrgId());
            incidentVO.setOrgName(e.getOrgName());
            incidentVO.setOrgCode(e.getOrgCode());
            incidentVO.setParentOrgId(e.getParentOrgId());
            incidentVO.setParentOrgName(e.getParentOrgName());
            incidentVO.setParentOrgCode(e.getParentOrgCode());
            incidentVO.setDate(new Date());
            incidentVO.setBuckleBranch(BigDecimal.ZERO);
            incidentVO.setSource("\u5b9a\u65f6\u63a8\u9001");
            incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
            incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
            list.add(incidentVO);
            ++billCodeIdx;
        }
        return list;
    }

    public List<IncidentVO> getProcessList(List<ContractPoolVO> pushProcessList, Map<Long, List<IncidentEntity>> map, IUserApi userApi, IBillCodeApi billCodeApi, SessionManager sessionManager) {
        ArrayList<IncidentVO> list = new ArrayList<IncidentVO>();
        pushProcessList.forEach(e -> {
            if (map == null) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                incidentVO.setCode((String)billCode.getData());
                incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(Integer.valueOf(0));
                incidentVO.setContractType(e.getSourceType());
                incidentVO.setContractName(e.getContractName());
                incidentVO.setContractCode(e.getContractCode());
                ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode((String)e.getSourceType());
                if (contractTypeEnum != null) {
                    String contractTypeName = ContractTypeEnum.getByCode((String)e.getSourceType()).getTypeName();
                    incidentVO.setContractTypeName(contractTypeName);
                }
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartybName());
                String supplyQueryType = SupplyQueryTypeUtil.get((String)"RULE_A", (String)e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setOrgId(e.getOrgId());
                incidentVO.setOrgName(e.getOrgName());
                incidentVO.setOrgCode(e.getOrgCode());
                incidentVO.setParentOrgId(e.getParentOrgId());
                incidentVO.setParentOrgName(e.getParentOrgName());
                incidentVO.setParentOrgCode(e.getParentOrgCode());
                incidentVO.setDate(new Date());
                incidentVO.setBuckleBranch(BigDecimal.ZERO);
                if (e.getPerformanceStatus().equals(ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode())) {
                    incidentVO.setSource("\u6700\u7ec8\u7ed3\u7b97");
                } else {
                    incidentVO.setSource("\u5b9a\u65f6\u63a8\u9001");
                }
                incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
                incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
                list.add(incidentVO);
            } else if (!map.containsKey(null != e.getContractId() ? e.getContractId() : e.getId())) {
                IncidentVO incidentVO = new IncidentVO();
                CommonResponse billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if (!billCode.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                incidentVO.setCode((String)billCode.getData());
                incidentVO.setContractId(null != e.getContractId() ? e.getContractId() : e.getId());
                incidentVO.setPerformanceStatus(e.getPerformanceStatus());
                incidentVO.setStatus(Integer.valueOf(0));
                incidentVO.setContractType(e.getSourceType());
                ContractTypeEnum contractTypeEnum = ContractTypeEnum.getByCode((String)e.getSourceType());
                if (contractTypeEnum != null) {
                    String contractTypeName = ContractTypeEnum.getByCode((String)e.getSourceType()).getTypeName();
                    incidentVO.setContractTypeName(contractTypeName);
                }
                incidentVO.setContractName(e.getContractName());
                incidentVO.setContractCode(e.getContractCode());
                incidentVO.setProjectId(e.getProjectId());
                incidentVO.setProjectName(e.getProjectName());
                incidentVO.setContractAmount(e.getContractTaxMny());
                incidentVO.setSupplyId(e.getPartybId());
                incidentVO.setSupplyName(e.getPartybName());
                String supplyQueryType = SupplyQueryTypeUtil.get((String)"RULE_A", (String)e.getSourceType());
                incidentVO.setSupplyQueryType(supplyQueryType);
                incidentVO.setOrgId(e.getOrgId());
                incidentVO.setOrgName(e.getOrgName());
                incidentVO.setOrgCode(e.getOrgCode());
                incidentVO.setParentOrgId(e.getParentOrgId());
                incidentVO.setParentOrgName(e.getParentOrgName());
                incidentVO.setParentOrgCode(e.getParentOrgCode());
                incidentVO.setDate(new Date());
                incidentVO.setBuckleBranch(BigDecimal.ZERO);
                if (e.getPerformanceStatus().equals(ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode())) {
                    incidentVO.setSource("\u6700\u7ec8\u7ed3\u7b97");
                } else {
                    incidentVO.setSource("\u5b9a\u65f6\u63a8\u9001");
                }
                incidentVO.setHeadUserId(e.getSupplierProjectManagerId());
                incidentVO.setHeadUserName(e.getSupplierProjectManagerName());
                list.add(incidentVO);
            }
        });
        return list;
    }
}

