package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.SupplyVO;
import com.ejianc.business.pro.supplier.bean.CertificateEntity;
import com.ejianc.business.pro.supplier.bean.LimitEntity;
import com.ejianc.business.pro.supplier.dto.CheckSupplierDTO;
import com.ejianc.business.pro.supplier.service.ICertificateService;
import com.ejianc.business.pro.supplier.service.ICheckSupplierService;
import com.ejianc.business.pro.supplier.service.ILimitService;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.LimitVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.CertsDTO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 校验供应商是否合格
 *
 * @author xuannl
 */
@Service("checkSupplierService")
public class CheckSupplierServiceImpl implements ICheckSupplierService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    IContractPoolApi contractPoolApi;

    @Override
    public CheckSupplierDTO queryCheckDTO(Long id,Long firstContentId) {
        CommonResponse<SupplierDTO> supplierDTOCommonResponse = proSupplierApi.selectById(id);
        logger.info("supplierDTOCommonResponse:" + JSONObject.toJSONString(supplierDTOCommonResponse));
        if (!supplierDTOCommonResponse.isSuccess() || supplierDTOCommonResponse.getData() == null) {
            logger.info("根据id查询供应商失败！");
            return null;
        }
        SupplierDTO supplierDTO = supplierDTOCommonResponse.getData();
        CheckSupplierDTO checkSupplierDTO = BeanMapper.map(supplierDTO, CheckSupplierDTO.class);

        //查询本等级各个分类的限额
       Long gradeId = checkSupplierDTO.getGradeId();
        String supplyType = checkSupplierDTO.getSupplyType();
        List<String> types = new ArrayList<>();
        if (!StringUtils.isEmpty(supplyType)) {
            String[] split = supplyType.split(",");
            for (String str : split
            ) {
                types.add(str);
            }
        }
        logger.info("types:" + types);
        if (types.size() > 0) {
            QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("gread_id", gradeId);
            wrapper.eq("state", 1);//默认查询启用的
            wrapper.in("supply_type", types);
            List<LimitEntity> limitList = limitService.list(wrapper);
            List<LimitVO> limitVOS = BeanMapper.mapList(limitList, LimitVO.class);
            checkSupplierDTO.setLimitVOS(limitVOS);
        }

        //父级证件
        List<CertsDTO> certs = checkSupplierDTO.getCerts();
        //子级的档案
        List<CertificateEntity> childrenList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(certs)){
            List<Long> certIds = new ArrayList<>();
            for (CertsDTO dto : certs
            ) {
//                certIds.add(dto.getCertId());
                QueryWrapper<CertificateEntity> queryChildrenWrapper = new QueryWrapper<>();
                queryChildrenWrapper.like("superior_id",dto.getCertId());
                List<CertificateEntity> list = certificateService.list(queryChildrenWrapper);
                childrenList.addAll(list);
            }
            if (CollectionUtils.isNotEmpty(childrenList)){
                for (CertificateEntity certificateEntity : childrenList) {
                    CertsDTO certsDTO = new CertsDTO();
                    certsDTO.setCertId(certificateEntity.getId());
                    certsDTO.setCertName(certificateEntity.getName());
                    certs.add(certsDTO);
                }
            }
            checkSupplierDTO.setCerts(certs);
//            QueryWrapper<CertificateEntity> certWrapper = new QueryWrapper<>();
//            certWrapper.in("id", certIds);
//            List<CertificateEntity> list = certificateService.list(certWrapper);
//            List<Long> fids = new ArrayList<>();
//            for (CertificateEntity entity : list
//            ) {
//                String superiorId = entity.getSuperiorId();
//                if (!StringUtils.isEmpty(superiorId)) {
//                    String[] split1 = superiorId.split(",");
//                    for (String str : split1
//                    ) {
//                        fids.add(Long.valueOf(str));
//                    }
//                }
//            }
//            logger.info("fids:" + fids);
//            if (fids.size() > 0) {
//                certWrapper = new QueryWrapper<>();
//                certWrapper.in("id", fids);
//                List<CertificateEntity> flist = certificateService.list(certWrapper);
//                for (CertificateEntity certificateEntity : flist) {
//                    certificateEntity.setTheScope(null);
//                }
//                List<CertificateVO> certificateVOS = BeanMapper.mapList(flist, CertificateVO.class);
//                checkSupplierDTO.setfCertificateVOS(certificateVOS);
//            }
        }


        //本年度累计合同额
        List<Long> supplierIds = new ArrayList<>();
        supplierIds.add(id);
        String startDate = DateUtil.getYear() + "-01-01";
        String endDate = DateUtil.getYear() + "-12-31";
        SupplyVO supplyVO = new SupplyVO();
        supplyVO.setSupplierIds(supplierIds);
        supplyVO.setStartDate(startDate);
        supplyVO.setEndDate(endDate);
        supplyVO.setFirstContentId(firstContentId);
        logger.info("supplyVO:" + JSONObject.toJSONString(supplyVO));
        CommonResponse<JSONArray> contractList = contractPoolApi.getContractList(supplyVO);
        logger.info("contractList:" + JSONObject.toJSONString(contractList));
        //CommonResponse<List<ContractDTO>> contractList = contractPoolApi.getContractList(supplyVO);

        if (!contractList.isSuccess() || contractList.getData() == null) {
            logger.info("查询合同池数据失败！");
            return null;
        }
        List<ContractDTO> contractListS = new ArrayList<>();
        for (Object object : contractList.getData()) {
            String str = JSONObject.toJSONString(object);
            logger.info("str:" + str);
            ContractDTO dto = JSONObject.parseObject(str, ContractDTO.class);
            logger.info("dto:" + JSONObject.toJSONString(dto));
            contractListS.add(dto);
        }
        BigDecimal sumMny = BigDecimal.ZERO;
        for (ContractDTO dto : contractListS
        ) {
            sumMny = sumMny.add(dto.getContractTaxMny());
        }
        checkSupplierDTO.setContractDTOS(contractListS);
        checkSupplierDTO.setSumContractMny(sumMny);
        logger.info("checkSupplierDTO:" + JSONObject.toJSONString(checkSupplierDTO));
        return checkSupplierDTO;
    }

}
