/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.ejianc.business.pro.supplier.bean.CanInEntity;
import com.ejianc.business.pro.supplier.bean.GradeEntity;
import com.ejianc.business.pro.supplier.bean.InvExpertEntity;
import com.ejianc.business.pro.supplier.bean.InvExpertLeaderEntity;
import com.ejianc.business.pro.supplier.bean.SubleaderCanInEntity;
import com.ejianc.business.pro.supplier.service.ICanInService;
import com.ejianc.business.pro.supplier.service.IGradeService;
import com.ejianc.business.pro.supplier.service.IInvExpertLeaderService;
import com.ejianc.business.pro.supplier.service.IInvExpertService;
import com.ejianc.business.pro.supplier.service.ISubcontractCanInService;
import com.ejianc.business.pro.supplier.service.ISubleaderCanInService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invExpertLeader")
public class InvExpertLeaderBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvExpertService iInvExpertService;
    @Autowired
    private IInvExpertLeaderService invExpertLeaderService;
    @Autowired
    private ICanInService canInService;
    @Autowired
    private IGradeService iGradeService;
    @Autowired
    private ISubcontractCanInService iSubcontractCanInService;
    @Autowired
    private ISubleaderCanInService subleaderCanInService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        InvExpertLeaderEntity leaderEntity = (InvExpertLeaderEntity)((Object)this.invExpertLeaderService.selectById(billId));
        if (leaderEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("canInId", new Parameter("eq", (Object)leaderEntity.getCanInId()));
        List list = this.iInvExpertService.queryList(param);
        for (InvExpertEntity expertEntity : list) {
            if ("2".equals(expertEntity.getState())) continue;
            return CommonResponse.error((String)"\u6240\u6709\u4e13\u5bb6\u5fc5\u987b\u5b8c\u6210\u8003\u5bdf\uff0c\u624d\u80fd\u8fdb\u884c\u6c47\u603b\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        InvExpertLeaderEntity leaderEntity = (InvExpertLeaderEntity)((Object)this.invExpertLeaderService.selectById(billId));
        if (leaderEntity == null) {
            return CommonResponse.error((String)"\u6ca1\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("canInId", new Parameter("eq", (Object)leaderEntity.getCanInId()));
        List list = this.iInvExpertService.queryList(param);
        this.logger.info("\u5ba1\u6279\u6d41\u63d0\u4ea4---\u6839\u636e\u8003\u5bdf\u89c4\u5219\uff0c\u63d0\u4ea4\u540e\u5c06\u975e\u5df2\u8003\u5bdf\u7f6e\u4e3a\u5df2\u8fc7\u671f\uff01billId-{},canInId-{}", (Object)billId, (Object)leaderEntity.getCanInId());
        for (InvExpertEntity expertEntity : list) {
            if ("2".equals(expertEntity.getState())) continue;
            expertEntity.setState("4");
            this.logger.info("\u5ba1\u6279\u6d41\u63d0\u4ea4---\u6839\u636e\u8003\u5bdf\u89c4\u5219\uff0c\u63d0\u4ea4\u540e\u5c06\u975e\u5df2\u8003\u5bdf\u7f6e\u4e3a\u5df2\u8fc7\u671f\uff01\u4e13\u5bb6-{},\u7f16\u7801-{}", (Object)expertEntity.getExportName(), (Object)expertEntity.getCode());
            this.iInvExpertService.saveOrUpdateNoES((Object)expertEntity);
        }
        leaderEntity.setSubmitDate(new Date());
        this.invExpertLeaderService.saveOrUpdate((Object)leaderEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BaseEntity canInEntity;
        InvExpertLeaderEntity entity = (InvExpertLeaderEntity)((Object)this.invExpertLeaderService.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        Long canInId = entity.getCanInId();
        Long gradeId = entity.getGradeId();
        if (state == 1) {
            QueryParam param = new QueryParam();
            param.getParams().put("collectId", new Parameter("eq", (Object)billId));
            List list = this.iInvExpertService.queryList(param);
            for (InvExpertEntity expertEntity : list) {
                if ("2".equals(expertEntity.getState())) continue;
                return CommonResponse.error((String)"\u6240\u6709\u4e13\u5bb6\u5fc5\u987b\u5b8c\u6210\u8003\u5bdf\uff0c\u624d\u80fd\u8fdb\u884c\u6c47\u603b\u63d0\u4ea4\uff01");
            }
            this.logger.info("\u76f4\u5ba1\u63d0\u4ea4 --- \u6839\u636e\u8003\u5bdf\u89c4\u5219\uff0c\u63d0\u4ea4\u540e\u5c06\u975e\u5df2\u8003\u5bdf\u7f6e\u4e3a\u5df2\u8fc7\u671f\uff01billId-{},canInId-{}", (Object)billId, (Object)canInId);
            for (InvExpertEntity expertEntity : list) {
                if ("2".equals(expertEntity.getState())) continue;
                expertEntity.setState("4");
                this.logger.info("\u76f4\u5ba1\u63d0\u4ea4 --- \u6839\u636e\u8003\u5bdf\u89c4\u5219\uff0c\u63d0\u4ea4\u540e\u5c06\u975e\u5df2\u8003\u5bdf\u7f6e\u4e3a\u5df2\u8fc7\u671f\uff01\u4e13\u5bb6-{},\u7f16\u7801-{}", (Object)expertEntity.getExportName(), (Object)expertEntity.getCode());
                this.iInvExpertService.saveOrUpdateNoES((Object)expertEntity);
            }
            entity.setSubmitDate(new Date());
            this.invExpertLeaderService.saveOrUpdate((Object)entity);
        }
        String gradeName = ((GradeEntity)((Object)this.iGradeService.selectById(gradeId))).getName();
        if ("\u5408\u683c".equals(entity.getResult())) {
            if (Objects.equals(entity.getSourceFrom(), "subLeader")) {
                return this.subleaderCanInService.pushSupplierToShare(canInId);
            }
            return this.canInService.afterInvestigate(canInId, gradeId, gradeName);
        }
        if (Objects.equals(entity.getSourceFrom(), "subLeader")) {
            canInEntity = (SubleaderCanInEntity)((Object)this.subleaderCanInService.selectById(canInId));
            canInEntity.setBillState(0);
            this.subleaderCanInService.saveOrUpdate(canInEntity, false);
        } else {
            canInEntity = (CanInEntity)((Object)this.canInService.selectById(canInId));
            canInEntity.setHasInvestigate(false);
            canInEntity.setBillState(0);
            this.canInService.saveOrUpdate(canInEntity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u4e0d\u652f\u6301\u9a73\u56de\u6216\u8005\u5f03\u5ba1\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

