/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.appraise;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.pro.supplier.bean.IncidentEntity;
import com.ejianc.business.pro.supplier.service.IIncidentService;
import com.ejianc.business.pro.supplier.service.appraise.IPushProcessRuleBLogic;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.AppraiseParamVO;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pushProcessRuleBLogic")
public class PushProcessRuleBLogic
implements IPushProcessRuleBLogic {
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    ISettlePoolApi settlePoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IIncidentService incidentService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "INCIDENT";

    @Override
    public void logicOne(AppraiseParamVO appraiseParamVO) {
        List contractPoolVOList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode())));
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)(contractPoolVOList = (List)listCommonResponse.getData()))) {
            ArrayList<ContractPoolVO> pushList = new ArrayList<ContractPoolVO>();
            contractPoolVOList.forEach(item -> {
                Date date = new Date();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"contract_id", (Object)item.getContractId());
                wrapper.eq((Object)"performance_status", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
                wrapper.eq((Object)"dr", (Object)0);
                wrapper.orderByDesc((Object)"date");
                List list = this.incidentService.list((Wrapper)wrapper);
                date = CollectionUtils.isNotEmpty((Collection)list) ? ((IncidentEntity)((Object)((Object)list.get(0)))).getDate() : item.getSignDate();
                int days = DateUtil.differentDays(new Date(), date);
                days = Math.abs(days);
                if (days >= appraiseParamVO.getSpaceLastDays()) {
                    pushList.add((ContractPoolVO)item);
                }
            });
            if (pushList.size() > 0) {
                this.saveIncident(pushList);
            }
        }
    }

    @Override
    public void logicTwo(AppraiseParamVO appraiseParamVO) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
        queryParam.getParams().put("sourceType", new Parameter("in", Arrays.asList(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode(), ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8f85\u6599\u4e2d\u5fc3\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode(), ContractTypeEnum.\u8bbe\u5907\u79df\u8d41.getTypeCode(), ContractTypeEnum.\u52b3\u52a1\u5206\u5305\u5408\u540c.getTypeCode(), ContractTypeEnum.\u4e13\u4e1a\u5206\u5305\u5408\u540c.getTypeCode())));
        CommonResponse listCommonResponse = this.contractPoolApi.queryList(queryParam);
        if (listCommonResponse.isSuccess()) {
            ArrayList<ContractPoolVO> pushList = new ArrayList<ContractPoolVO>();
            List conList = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)conList)) {
                List contractPoolIds = conList.stream().map(BaseVO::getId).collect(Collectors.toList());
                QueryParam queryIncidentParam = new QueryParam();
                queryIncidentParam.getParams().put("contractId", new Parameter("in", contractPoolIds));
                queryIncidentParam.getParams().put("performanceStatus", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode()));
                List incidentList = this.incidentService.queryList(queryIncidentParam, false);
                Map<Long, IncidentEntity> map = incidentList.stream().collect(Collectors.toMap(k -> k.getContractId(), k -> k));
                if (incidentList.size() == 0) {
                    pushList.addAll(conList);
                } else {
                    conList.forEach(item -> {
                        if (!map.containsKey(item.getContractId())) {
                            pushList.add((ContractPoolVO)item);
                        }
                    });
                }
                this.saveIncident(pushList);
            }
        }
    }

    public void saveIncident(List<ContractPoolVO> list) {
        ArrayList pushList = new ArrayList();
        list.forEach(e -> {
            IncidentEntity entity = new IncidentEntity();
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setContractId(e.getContractId());
            entity.setPerformanceStatus(e.getPerformanceStatus());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            CommonResponse voCommonResponse = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
            if (voCommonResponse.isSuccess()) {
                UserVO user = (UserVO)voCommonResponse.getData();
                entity.setCreateUserName(user.getUserName());
                entity.setPhone(user.getUserMobile());
            }
            entity.setProcessId(this.sessionManager.getUserContext().getUserId());
            entity.setProcess(this.sessionManager.getUserContext().getUserName());
            entity.setContractType(e.getSourceTypeName());
            entity.setContractName(e.getContractName());
            entity.setProjectId(e.getProjectId());
            entity.setProjectName(e.getProjectName());
            entity.setContractAmount(e.getContractTaxMny());
            entity.setSupplyId(e.getPartybId());
            entity.setSupplyName(e.getPartyaName());
            entity.setSupplyQueryType(SupplyQueryTypeUtil.get((String)"RULE_B", (String)e.getSourceType()));
            entity.setCheckOrgId(this.sessionManager.getUserContext().getOrgId());
            entity.setCheckOrgName(this.sessionManager.getUserContext().getOrgName());
            entity.setDate(new Date());
            entity.setSource("\u5b9a\u65f6\u63a8\u9001");
            pushList.add(entity);
        });
        if (pushList.size() > 0) {
            this.incidentService.saveOrUpdateBatch(pushList, pushList.size());
        }
    }
}

