/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.mapper.ProcessMapper;
import com.ejianc.business.pro.supplier.service.IProcessService;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.ProcessVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="processService")
public class ProcessServiceImpl
extends BaseServiceImpl<ProcessMapper, ProcessEntity>
implements IProcessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProcessMapper processMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Override
    public List<EvaluateHistoryVO> queryHistoryList(Long supplyId) {
        return this.processMapper.queryHistoryList(supplyId);
    }

    @Override
    public CommonResponse<String> syncProcess(ProcessVO saveOrUpdateVO) {
        this.logger.info("i8\u4f20\u8f93-\u4f9b\u5e94\u5546\u4e8b\u4ef6\u8bc4\u4ef7-\u63a5\u6536\u4f20\u53c2-saveOrUpdateVO" + JSONObject.toJSONString((Object)saveOrUpdateVO));
        String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        StringBuilder authtoken = new StringBuilder();
        try {
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                this.logger.info("\u62fc\u63a5\u9274\u6743\uff1a" + authtoken.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8c03\u5ea6\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38, ", (Throwable)e);
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
        ArrayList<String> createDataCodeList = new ArrayList<String>();
        ArrayList updateDataIdList = new ArrayList();
        ArrayList updateDataCodeList = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getUnitI8Code())) {
            return CommonResponse.error((String)"\u63a5\u53e3\u4f20\u8f93\u5931\u8d25\uff0ci8\u5355\u4f4d\u7f16\u7801\u672a\u4f20\u503c \uff01");
        }
        List processList = super.list((Wrapper)new QueryWrapper().eq((Object)"unit_i8_code", (Object)saveOrUpdateVO.getUnitI8Code()));
        ProcessEntity processEntity = null;
        CommonResponse listCommonResponse = this.iProSupplierApi.selectSupplierByUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        if (!listCommonResponse.isSuccess()) {
            return CommonResponse.error((String)"\u672a\u627e\u5230\u5bf9\u5e94i8\u5355\u4f4d\u7f16\u7801\u4f9b\u5e94\u5546\uff0c\u8bf7\u63a8\u9001\u4f9b\u5e94\u5546\u540e\u518d\u505a\u8bc4\u4ef7\uff01");
        }
        SupplierDTO supplierDTO = (SupplierDTO)listCommonResponse.getData();
        this.logger.info("\u67e5\u51fa\u5bf9\u5e94\u4f9b\u5e94\u5546-----" + JSONObject.toJSONString((Object)supplierDTO));
        if (CollectionUtils.isNotEmpty((Collection)processList) && processList.size() > 0) {
            return CommonResponse.error((String)"\u5f53\u524di8\u5355\u4f4d\u7f16\u7801\u6570\u636e\u5df2\u63a8\u9001\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        processEntity = new ProcessEntity();
        processEntity.setId(IdWorker.getId());
        processEntity.setTenantId(999999L);
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"code", (Object)saveOrUpdateVO.getCode());
        List billCodeEntityList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)billCodeEntityList)) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
        }
        processEntity.setCode(saveOrUpdateVO.getCode());
        createDataCodeList.add(saveOrUpdateVO.getCode());
        processEntity.setProjectId(saveOrUpdateVO.getProjectId());
        processEntity.setProjectName(saveOrUpdateVO.getProjectName());
        CommonResponse projectCommonResponse = this.projectPoolApi.queryProjectListByCodeAndTenantId(saveOrUpdateVO.getProjectCode(), Long.valueOf(999999L));
        if (!projectCommonResponse.isSuccess() || projectCommonResponse.getData() == null || ((List)projectCommonResponse.getData()).size() == 0) {
            return CommonResponse.error((String)("\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01" + projectCommonResponse.getMsg()));
        }
        this.logger.info("\u83b7\u53d6\u9879\u76ee\u4fe1\u606f----" + JSONObject.toJSONString((Object)projectCommonResponse.getData()));
        ProjectPoolSetVO projectVO = (ProjectPoolSetVO)((List)projectCommonResponse.getData()).get(0);
        processEntity.setOrgId(projectVO.getProjectDepartmentId());
        processEntity.setOrgName(projectVO.getOrgName());
        processEntity.setParentOrgId(projectVO.getOrgId());
        processEntity.setParentOrgName(projectVO.getOrgName());
        processEntity.setCheckOrgId(projectVO.getOrgId());
        processEntity.setCheckOrgName(projectVO.getOrgName());
        processEntity.setProjectId(projectVO.getId());
        processEntity.setContractId(saveOrUpdateVO.getContractId());
        processEntity.setContractCode(saveOrUpdateVO.getContractCode());
        processEntity.setContractName(saveOrUpdateVO.getContractName());
        processEntity.setSupplyId(supplierDTO.getId());
        processEntity.setSupplyName(supplierDTO.getSupplyTypeName());
        processEntity.setBuckleBranch(saveOrUpdateVO.getBuckleBranch());
        processEntity.setDate(saveOrUpdateVO.getDate());
        processEntity.setUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        processEntity.setI8Url(saveOrUpdateVO.getI8Url());
        processEntity.setBillState(1);
        processEntity.setSourceType("i8");
        processEntity.setProcess(saveOrUpdateVO.getProcess());
        if (null != supplierDTO.getMainBusinessCategory()) {
            if ("materialEquipment".equals(supplierDTO.getMainBusinessCategory()) || "revolvMaterial".equals(supplierDTO.getMainBusinessCategory()) || "equipment".equals(supplierDTO.getMainBusinessCategory())) {
                processEntity.setSupplyQueryType("materialEquipment");
            } else if ("labor".equals(supplierDTO.getMainBusinessCategory()) || "major".equals(supplierDTO.getMainBusinessCategory())) {
                processEntity.setSupplyQueryType("sub");
            } else {
                processEntity.setSupplyQueryType("other");
            }
        }
        super.saveOrUpdate((Object)processEntity, false);
        this.logger.info("i8\u4f20\u8f93-\u4f9b\u5e94\u5546\u4e8b\u4ef6\u8bc4\u4ef7-\u4fdd\u5b58\u6210\u529f-saveOrUpdateVO");
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }
}

