package com.ejianc.business.pro.supplier.service.impl;

import bsh.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.bid.vo.bidAreaVO.ProjectVo;
import com.ejianc.business.pro.supplier.vo.EvaluateHistoryVO;
import com.ejianc.business.pro.supplier.vo.ProcessVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.ProcessMapper;
import com.ejianc.business.pro.supplier.bean.ProcessEntity;
import com.ejianc.business.pro.supplier.service.IProcessService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 事件评价
 * 
 * @author generator
 * 
 */
@Service("processService")
public class ProcessServiceImpl extends BaseServiceImpl<ProcessMapper, ProcessEntity> implements IProcessService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProcessMapper processMapper;
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Override
    public List<EvaluateHistoryVO> queryHistoryList(Long supplyId) {
        return processMapper.queryHistoryList(supplyId);
    }

    @Override
    public CommonResponse<String> syncProcess(ProcessVO saveOrUpdateVO) {
        logger.info("i8传输-供应商事件评价-接收传参-saveOrUpdateVO" + JSONObject.toJSONString(saveOrUpdateVO));
        String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        StringBuilder authtoken = new StringBuilder();
        try {
            CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
            if(userContextResponse.isSuccess()) {
                JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
                authtoken.append("userType=").append(userContext.get("userType"))
                        .append(";userCode=").append(userContext.get("userCode"))
                        .append(";orgId=").append(userContext.get("orgId"))
                        .append(";tenantid=").append(userContext.get("tenantid"))
                        .append(";token=").append(userContext.get("token"))
                        .append(";u_logints=").append(userContext.get("u_logints"))
                        .append(";u_usercode=").append(userContext.get("u_usercode"))
                        .append(";userId=").append(userContext.get("userId"));
                logger.info("拼接鉴权：" + authtoken.toString());
            }
        } catch (Exception e) {
            logger.error("获取调度任务上下文异常, ", e);
        }
        InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());


        List<String> createDataCodeList = new ArrayList<>();
        List<Long> updateDataIdList = new ArrayList<>();
        List<String> updateDataCodeList = new ArrayList<>();



        if (StringUtils.isEmpty(saveOrUpdateVO.getUnitI8Code())){
            return CommonResponse.error("接口传输失败，i8单位编码未传值 ！");
        }
        List<ProcessEntity> processList = super.list(new QueryWrapper<ProcessEntity>().eq("unit_i8_code", saveOrUpdateVO.getUnitI8Code()));
        ProcessEntity processEntity = null;

        CommonResponse<SupplierDTO> listCommonResponse = iProSupplierApi.selectSupplierByUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        if (!listCommonResponse.isSuccess()){
            return CommonResponse.error("未找到对应i8单位编码供应商，请推送供应商后再做评价！");
        }
        SupplierDTO supplierDTO = listCommonResponse.getData();
        logger.info("查出对应供应商-----" + JSONObject.toJSONString(supplierDTO));

        if (CollectionUtils.isNotEmpty(processList) && processList.size() > 0){
            return CommonResponse.error("当前i8单位编码数据已推送，请勿重复推送！");
        }else {
            processEntity = new ProcessEntity();
            processEntity.setId(IdWorker.getId());
            processEntity.setTenantId(999999L);

            //编号重复校验
            QueryWrapper<ProcessEntity> query = new QueryWrapper();
            query.eq("code", saveOrUpdateVO.getCode());
            List<ProcessEntity> billCodeEntityList = super.list(query);
            if(CollectionUtils.isNotEmpty(billCodeEntityList)) {
                return CommonResponse.error("保存失败，编码重复！");
            }

            processEntity.setCode(saveOrUpdateVO.getCode());
            createDataCodeList.add(saveOrUpdateVO.getCode());
        }

        processEntity.setProjectId(saveOrUpdateVO.getProjectId());
        processEntity.setProjectName(saveOrUpdateVO.getProjectName());


        //1.根据项目编码获得项目信息赋值
        CommonResponse<List<ProjectPoolSetVO>> projectCommonResponse = projectPoolApi.queryProjectListByCodeAndTenantId(saveOrUpdateVO.getProjectCode(), 999999L);
        if (!projectCommonResponse.isSuccess() || projectCommonResponse.getData() == null || projectCommonResponse.getData().size() == 0){
            return CommonResponse.error("保存失败，获取项目信息失败！" + projectCommonResponse.getMsg());
        }
        logger.info("获取项目信息----" + JSONObject.toJSONString(projectCommonResponse.getData()));

        ProjectPoolSetVO projectVO = projectCommonResponse.getData().get(0);
        processEntity.setOrgId(projectVO.getProjectDepartmentId());
        processEntity.setOrgName(projectVO.getOrgName());
        processEntity.setParentOrgId(projectVO.getOrgId());
        processEntity.setParentOrgName(projectVO.getOrgName());
        processEntity.setCheckOrgId(projectVO.getOrgId());
        processEntity.setCheckOrgName(projectVO.getOrgName());

        processEntity.setProjectId(projectVO.getId());

        processEntity.setContractId(saveOrUpdateVO.getContractId());
        processEntity.setContractCode(saveOrUpdateVO.getContractCode());
        processEntity.setContractName(saveOrUpdateVO.getContractName());

        processEntity.setSupplyId(supplierDTO.getId());
        processEntity.setSupplyName(supplierDTO.getName());

        processEntity.setBuckleBranch(saveOrUpdateVO.getBuckleBranch());
        processEntity.setDate(saveOrUpdateVO.getDate());
        processEntity.setUnitI8Code(saveOrUpdateVO.getUnitI8Code());
        processEntity.setI8Url(saveOrUpdateVO.getI8Url());

        processEntity.setBillState(1);
        processEntity.setSourceType("i8");

        processEntity.setProcess(saveOrUpdateVO.getProcess());


        if (null != supplierDTO.getMainBusinessCategory()){
            if ("materialEquipment".equals(supplierDTO.getMainBusinessCategory()) || "revolvMaterial".equals(supplierDTO.getMainBusinessCategory()) || "equipment".equals(supplierDTO.getMainBusinessCategory())){
                processEntity.setSupplyQueryType("materialEquipment");
            }else if ("labor".equals(supplierDTO.getMainBusinessCategory()) || "major".equals(supplierDTO.getMainBusinessCategory())){
                processEntity.setSupplyQueryType("sub");
            }else {
                processEntity.setSupplyQueryType("other");
            }
        }
//        processEntity.setSupplyQueryType(supplierDTO.getSupplyQueryType());

        super.saveOrUpdate(processEntity, false);


        logger.info("i8传输-供应商事件评价-保存成功-saveOrUpdateVO");
        return CommonResponse.success("保存或修改单据成功！");
    }
}
