package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.supplier.vo.SupplierGroupVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pro.supplier.mapper.SupplierGroupMapper;
import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.service.ISupplierGroupService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 集团供应商库表
 * 
 * @author generator
 * 
 */
@Service("supplierGroupService")
public class SupplierGroupServiceImpl extends BaseServiceImpl<SupplierGroupMapper, SupplierGroupEntity> implements ISupplierGroupService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi iProSupplierApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IDefdocApi defdocApi;

    @Value("${common.env.base-host}")
    private String baseHost;
    private static String SUPPLY_CODE = "pro-supply-can-in-org-nature";


    @Override
    public CommonResponse<SupplierGroupVO> pushSupplierToPool(Long id, boolean updateNameFlag) {
        logger.info("推送供应商！");
        SupplierGroupEntity entity = super.selectById(id);

        logger.info("entity----{}", JSONObject.toJSONString(entity));

        //是否 只有分包负责人引用了？
        if (updateNameFlag && entity.getSupplierType().contains("subPerson")){
            Integer updateLeaderNum = baseMapper.updateSubLeader(entity.getCertificateCode(), entity.getName());
            logger.info("更新分包负责人数量 " + updateLeaderNum + " 条！");
            if ("subPerson".equals(entity.getSupplierType())){
                return CommonResponse.success("更新分包负责人成功！");
            }
        }


        CommonResponse<SupplierVO> supplierVOCommonResponse = iProSupplierApi.selectBySupplierGroupId(entity.getId());
        logger.info("supplierVOCommonResponse----{}", JSONObject.toJSONString(supplierVOCommonResponse));
        if (!supplierVOCommonResponse.isSuccess()){
            throw new BusinessException("网络异常， 查询供应商库失败， 请稍后再试");
        }
        SupplierVO supplierVO = supplierVOCommonResponse.getData();
        if (null == supplierVO || null == supplierVO.getId()){
            if (!entity.getSupplierType().contains("subPerson")) {
                throw new BusinessException("供应商库不存在该供应商，请先做供应商准入！");
            }else {
                if (updateNameFlag){
                    //更新分包负责人
                    Integer updateLeaderNum = baseMapper.updateSubLeader(entity.getCertificateCode(), entity.getName());
                    logger.info("更新分包负责人数量 " + updateLeaderNum + " 条！");
                }
                return CommonResponse.success("更新分包负责人成功！");
            }
        }

        //更新供应商库字段
        supplierVO.setInOrOut(StringUtils.isNotBlank(entity.getGroupInOrOut()) && "in".equals(entity.getGroupInOrOut()) ? 0 : 1);
        supplierVO.setFormerName(supplierVO.getName());
        supplierVO.setUnitI8Code(entity.getCode());
        supplierVO.setEnterpriseNature(entity.getEnterpriseNature());
        supplierVO.setEnterpriseNatureName(entity.getEnterpriseNatureName());
        supplierVO.setName(entity.getName());
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());
        supplierVO.setRegisterTime(entity.getRegisterDate());

        supplierVO.setRegisterCountryName(entity.getRegisterCountryName());
        supplierVO.setAreaName(entity.getAreaName());

        supplierVO.setAddress(entity.getAddress());
        supplierVO.setLegal(entity.getLegalPerson());
        supplierVO.setLegalPhone(entity.getLegalPhone());
        supplierVO.setBusinessPerson(entity.getBusinessPerson());
        supplierVO.setBusinessPhone(entity.getBusinessPhone());
        supplierVO.setRegisteredCapital(entity.getRegisterMny());

        supplierVO.setTaxpayerType(entity.getTaxIdentityType());
        supplierVO.setTaxPayerTypeName(entity.getTaxIdentityTypeName());
        supplierVO.setBillingAddress(entity.getBillingAddress());
        supplierVO.setBillingPhone(entity.getBillingPhone());
        supplierVO.setBankAccountName(entity.getBankName());
        supplierVO.setBankAccountCode(entity.getBankAccount());

        supplierVO.setSupplierGroupId(id);
        supplierVO.setBlacklistFlag(entity.getBlacklistFlag());

        iProSupplierApi.updateSupplierByGroup(supplierVO);

        // 处理附件
        CommonResponse<String> fileRes = attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202506000003", "businessLicenseFile",
                String.valueOf(supplierVO.getId()), "BT200422000000028", "K1639384499212");//营业执照
        logger.info("fileRes---{}", JSONObject.toJSONString(fileRes));


        logger.info("pushSupplierToShare----{}", JSONObject.toJSONString(supplierVO));


        //更新合同字段
        logger.info("更新合同标识----" + (updateNameFlag ? "是" : "否"));
        if (updateNameFlag){
            Integer updateNum = baseMapper.updateContractSupplier(supplierVO.getId(), entity.getName());
            logger.info("更新合同数量 " + updateNum + " 条！");
        }

        return CommonResponse.success("更新供应商库成功", BeanMapper.map(entity, SupplierGroupVO.class));
    }

    @Override
    public CommonResponse<String> syncSupplierGroup(List<SupplierGroupVO> saveOrUpdateVOs) {
        logger.info("i8传输集团供应商库接口-接收传参saveOrUpdateVOs" + JSONObject.toJSONString(saveOrUpdateVOs));
        List<String> createDataCodeList = new ArrayList<>();
        List<Long> updateDataIdList = new ArrayList<>();
        List<String> updateDataCodeList = new ArrayList<>();
        List<Long> updateNameList = new ArrayList<>();

        List<SupplierGroupEntity> saveOrUpdateList = new ArrayList<>();


        List<String> sourceCodeList = saveOrUpdateVOs.stream().map(SupplierGroupVO::getCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sourceCodeList)){
            return CommonResponse.error("接口传输失败，档案主键sourceId未传值 ！");
        }
        List<SupplierGroupEntity> supplierGroupList = super.list(new QueryWrapper<SupplierGroupEntity>().in("code", sourceCodeList));
        Map<String, SupplierGroupEntity> supplierGroupMap = supplierGroupList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e));

        Map<String, Long> defMap = new HashMap<>();
        CommonResponse<List<DefdocDetailVO>> defDocByDefCode = defdocApi.getDefDocByDefCode(SUPPLY_CODE);
        if(defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty(defDocByDefCode.getData())){
            defMap = defDocByDefCode.getData().stream().collect(Collectors.toMap(DefdocDetailVO::getName, DefdocDetailVO::getId));
        }

        for (SupplierGroupVO saveOrUpdateVO : saveOrUpdateVOs) {
            SupplierGroupEntity supplierGroupEntity = null;
            if(supplierGroupMap.containsKey(saveOrUpdateVO.getCode())) {
                //更新
                supplierGroupEntity = supplierGroupMap.get(saveOrUpdateVO.getCode());
                if (!supplierGroupEntity.getName().equals(saveOrUpdateVO.getName())){
                    updateNameList.add(supplierGroupEntity.getId());
                }
                updateDataCodeList.add(saveOrUpdateVO.getCode());
                updateDataIdList.add(saveOrUpdateVO.getId());
            }else{
                //新增
                supplierGroupEntity = new SupplierGroupEntity();
                supplierGroupEntity.setId(IdWorker.getId());
                supplierGroupEntity.setTenantId(999999L);

                supplierGroupEntity.setCode(saveOrUpdateVO.getCode());
                createDataCodeList.add(saveOrUpdateVO.getCode());
            }

            supplierGroupEntity.setName(saveOrUpdateVO.getName());
            supplierGroupEntity.setEnterpriseNatureName(saveOrUpdateVO.getEnterpriseNatureName());
            supplierGroupEntity.setShortName(saveOrUpdateVO.getShortName());
            supplierGroupEntity.setEnglishShortName(saveOrUpdateVO.getEnglishShortName());
            supplierGroupEntity.setFormerName(saveOrUpdateVO.getFormerName());
            supplierGroupEntity.setSocialCreditCode(saveOrUpdateVO.getSocialCreditCode());
            supplierGroupEntity.setTaxpayerNum(saveOrUpdateVO.getTaxpayerNum());
            supplierGroupEntity.setCertificateTypeName(saveOrUpdateVO.getCertificateTypeName());
            supplierGroupEntity.setCertificateCode(saveOrUpdateVO.getCertificateCode());
            supplierGroupEntity.setRegisterCountryName(saveOrUpdateVO.getRegisterCountryName());
            supplierGroupEntity.setGroupInOrOut(saveOrUpdateVO.getGroupInOrOut());

            supplierGroupEntity.setAreaName(saveOrUpdateVO.getAreaName());
            supplierGroupEntity.setLegalPerson(saveOrUpdateVO.getLegalPerson());
            supplierGroupEntity.setLegalPhone(saveOrUpdateVO.getLegalPhone());
            supplierGroupEntity.setSupplierTypeName(saveOrUpdateVO.getSupplierTypeName());
            supplierGroupEntity.setBlacklistFlag(saveOrUpdateVO.getBlacklistFlag());
            supplierGroupEntity.setBusinessPerson(saveOrUpdateVO.getBusinessPerson());
            supplierGroupEntity.setBusinessPhone(saveOrUpdateVO.getBusinessPhone());
            supplierGroupEntity.setMainDataCode(saveOrUpdateVO.getMainDataCode());
            supplierGroupEntity.setSourceI8Id(saveOrUpdateVO.getSourceI8Id());
            supplierGroupEntity.setMemo(saveOrUpdateVO.getMemo());

            supplierGroupEntity.setTaxIdentityType(saveOrUpdateVO.getTaxIdentityType());
            supplierGroupEntity.setTaxIdentityTypeName(saveOrUpdateVO.getTaxIdentityTypeName());
            supplierGroupEntity.setBankCode(saveOrUpdateVO.getBankCode());
            supplierGroupEntity.setBankName(saveOrUpdateVO.getBankName());
            supplierGroupEntity.setBankAccount(saveOrUpdateVO.getBankAccount());
            supplierGroupEntity.setBillingAddress(saveOrUpdateVO.getBillingAddress());
            supplierGroupEntity.setBillingPhone(saveOrUpdateVO.getBillingPhone());
            supplierGroupEntity.setRegisterDate(saveOrUpdateVO.getRegisterDate());
            supplierGroupEntity.setAddress(saveOrUpdateVO.getAddress());
            supplierGroupEntity.setRegisterMny(saveOrUpdateVO.getRegisterMny());
            supplierGroupEntity.setBusinessRange(saveOrUpdateVO.getBusinessRange());
            supplierGroupEntity.setTimeOut(saveOrUpdateVO.getTimeOut());

//            supplierGroupEntity.setLegalFileBase64(saveOrUpdateVO.getLegalFileBase64());
//            supplierGroupEntity.setLegalFilePath(saveOrUpdateVO.getLegalFilePath());
            supplierGroupEntity.setBusinessLicenseBase64(saveOrUpdateVO.getBusinessLicenseBase64());
            supplierGroupEntity.setBusinessLicensePath(saveOrUpdateVO.getBusinessLicensePath());
//            supplierGroupEntity.setAccountPermitBase64(saveOrUpdateVO.getAccountPermitBase64());
//            supplierGroupEntity.setAccountPermitPath(saveOrUpdateVO.getAccountPermitPath());

            if (null != supplierGroupEntity.getSupplierTypeName()){
                switch (supplierGroupEntity.getSupplierTypeName()) {
                    case "企业":
                        supplierGroupEntity.setSupplierType("enterprise");
                        break;
                    case "个人":
                        supplierGroupEntity.setSupplierType("person");
                        break;
                    case "个人,分包负责人":
                        supplierGroupEntity.setSupplierType("person,subPerson");
                        break;
                    default:
                        supplierGroupEntity.setSupplierType("subPerson");
                        break;
                }
            }
            // 企业性质名称/单位属性
            logger.info("defMap------" + JSONObject.toJSONString(defMap));
            if (defMap.containsKey(supplierGroupEntity.getEnterpriseNatureName())){
                supplierGroupEntity.setEnterpriseNature(defMap.get(supplierGroupEntity.getEnterpriseNatureName()));
            }else {
                logger.info("找不到对应文本对应自定义档案---code" + supplierGroupEntity.getCode());
            }

            if (null == supplierGroupEntity.getSyncTime()){
                supplierGroupEntity.setSyncTime(new Date());
            }
            supplierGroupEntity.setLatestUpdateTime(new Date());

            saveOrUpdateList.add(supplierGroupEntity);
        }

        super.saveOrUpdateBatch(saveOrUpdateList, saveOrUpdateList.size(), false);

        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                logger.info("进入线程！");
                //获取鉴权

                //获取鉴权
                String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
                String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
                StringBuilder authtoken = new StringBuilder();
                try {
                    CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
                    if(userContextResponse.isSuccess()) {
                        JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
                        authtoken.append("userType=").append(userContext.get("userType"))
                                .append(";userCode=").append(userContext.get("userCode"))
                                .append(";orgId=").append(userContext.get("orgId"))
                                .append(";tenantid=").append(userContext.get("tenantid"))
                                .append(";token=").append(userContext.get("token"))
                                .append(";u_logints=").append(userContext.get("u_logints"))
                                .append(";u_usercode=").append(userContext.get("u_usercode"))
                                .append(";userId=").append(userContext.get("userId"));
                        logger.info("拼接鉴权：" + authtoken.toString());
                    }
                } catch (Exception e) {
                    logger.error("获取调度任务上下文异常, ", e);
                }
                InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());


                //附件处理
                for (SupplierGroupEntity entity : saveOrUpdateList) {
                    uploadFile(entity);
                }
                logger.info("更新附件数" + saveOrUpdateList.size());

                //修改供应商
                if (updateDataIdList.size() > 0){
                    logger.info("更新id集合--updateDataIdList--" + JSONObject.toJSONString(updateDataIdList));
                    logger.info("更新合同id集合--updateNameList--" + JSONObject.toJSONString(updateNameList));
                    for (Long id : updateDataIdList) {
                        pushSupplierToPool(id, updateNameList.contains(id) ? true : false);
                    }
                    logger.info("修改供应商" + updateDataIdList.size());
                }
                logger.info("线程结束！");
            }
        });
        thread.start();
        logger.info("线程后输出");

        return CommonResponse.success("保存或修改单据成功！");
    }

    private void uploadFile(SupplierGroupEntity entity) {
        logger.info("附件更新！");
//        List<String> legalFileListBase64 = new ArrayList<>();
//        List<String> legalFileList = new ArrayList<>();
        List<String> businessLicenseListBase64 = new ArrayList<>();
        List<String> businessLicenseList = new ArrayList<>();
//        List<String> accountPermitListBase64 = new ArrayList<>();
//        List<String> accountPermitList = new ArrayList<>();

        if(StringUtils.isNotEmpty(entity.getBusinessLicenseBase64())){
            businessLicenseListBase64.add(entity.getBusinessLicenseBase64());
        }
        logger.info("接收附件地址：" + JSONObject.toJSONString(entity.getBusinessLicensePath()));
        if(null != entity.getBusinessLicensePath()){
            businessLicenseList.addAll(Arrays.asList(entity.getBusinessLicensePath()));
        }
        logger.info("接收附件地址转换：" + JSONObject.toJSONString(businessLicenseList));

        //base64处理
        if(CollectionUtils.isNotEmpty(businessLicenseListBase64)){
            AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
            attachmentVO.setBillType("EJCBT202506000003");
            attachmentVO.setSourceId(entity.getId().toString());
            attachmentVO.setSourceType("payBill");
            attachmentVO.setHandleImg(false);
            attachmentVO.setClearBeforeSave(false);
            attachmentVO.setFileList(businessLicenseListBase64);
            attachmentApi.uploadForBase64(attachmentVO);
        }

        //地址处理
        if(CollectionUtils.isNotEmpty(businessLicenseList)){
            List<AttachmentVO> list = new ArrayList<>();
            businessLicenseList.forEach(e->{
                logger.info("filePath--------：" +  e);
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType("EJCBT202506000003");
                attachmentVO.setSourceId(entity.getId());
                attachmentVO.setSourceType("payBill");
                attachmentVO.setFilePath(e);
                attachmentVO.setOnlinePath(e);
                int index = e.indexOf("&fileName=");
                int indexEnd = e.indexOf("&dbToken");
                String fileName = e.substring(index + 10, indexEnd);
                attachmentVO.setFileName(fileName);
                attachmentVO.setUploadUserName("i8");
//                    attachmentVO.setFileName("");
                list.add(attachmentVO);
            });
            CommonResponse<String> stringCommonResponse = attachmentApi.insertBatch(list);
            logger.info("传输附件信息----" + stringCommonResponse.getMsg());
        }

    }


}
