package com.ejianc.business.pro.supplier.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.pro.supplier.bean.SubcontractYearEntity;
import com.ejianc.business.pro.supplier.service.ISubcontractYearService;
import com.ejianc.business.pro.supplier.service.appraise.RuleBAppraiseStrategy;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.SubcontractYearVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包供应商年度评价
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractYear")
public class SubcontractYearController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private RuleBAppraiseStrategy rule;
    private static final String BILL_CODE = "YEAY_EVALUATE";//此处需要根据实际修改

    @Autowired
    private ISubcontractYearService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractYearVO> saveOrUpdate(@RequestBody SubcontractYearVO saveorUpdateVO) {
        SubcontractYearEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractYearEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setCreateUserId(InvocationInfoProxy.getUserid());
        CommonResponse<UserVO> voCommonResponse =userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if(voCommonResponse.isSuccess()){
            UserVO user =voCommonResponse.getData();
            entity.setCreateUserName(user.getUserName());
            entity.setPhone(user.getUserMobile());
        }
        entity.setOrgId(sessionManager.getUserContext().getOrgId());
        entity.setOrgCode(sessionManager.getUserContext().getOrgCode());
        entity.setOrgName(sessionManager.getUserContext().getOrgName());
        service.saveOrUpdate(entity, false);
        SubcontractYearVO vo = BeanMapper.map(entity, SubcontractYearVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractYearVO> queryDetail(Long id) {
        SubcontractYearEntity entity = service.selectById(id);
        SubcontractYearVO vo = BeanMapper.map(entity, SubcontractYearVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractYearVO> vos) {
        service.removeByIds(vos.stream().map(SubcontractYearVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractYearVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("supplyName");
        param.getFuzzyFields().add("cooperationOrgName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //param.getParams().put("supplyQueryType", new Parameter(QueryParam.EQ, SupplierQueryType.laborSub));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubcontractYearEntity> page = service.queryPage(param,false);
        IPage<SubcontractYearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractYearVO.class));
        List<SubcontractYearVO> records = pageData.getRecords();
        records.forEach(item->{
            if(item.getContractType() != null && ContractTypeEnum.getByCode(item.getContractType())!=null){
                item.setContractTypeName(ContractTypeEnum.getByCode(item.getContractType()).getTypeName());
            }
        });
        pageData.setRecords(records);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("supplyName");
        fuzzyFields.add("cooperationOrgName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<SubcontractYearEntity> list = service.queryList(param);
        List<SubcontractYearVO> records = BeanMapper.mapList(list, SubcontractYearVO.class);
        records.forEach(item->{
            if(item.getContractType() != null && ContractTypeEnum.getByCode(item.getContractType())!=null){
                item.setContractTypeName(ContractTypeEnum.getByCode(item.getContractType()).getTypeName());
            }
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", records);
        ExcelExport.getInstance().export("Year-sub-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refYearData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractYearVO>> refYearData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubcontractYearEntity> page = service.queryPage(param,false);
        IPage<SubcontractYearVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractYearVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    /**
     * 查询合作次数
     * @param supplyId
     * @return
     */
    @RequestMapping(value = "/querySubcontractRecordList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> querySubcontractRecordList(Long id,Long supplyId){
        SubcontractYearEntity subcontractYearEntity = service.selectById(id);
        String startDate = subcontractYearEntity.getOldStartDate();
        String endDate = DateUtil.format(subcontractYearEntity.getEndDate(), DateUtil.DATE);
        List<Map<String,Object>> subGrade = rule.getSubGrade2(supplyId,startDate,endDate);
        return CommonResponse.success("查询成功！",subGrade);
    }
}
