package com.ejianc.business.pro.supplier.service.appraise;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.dto.ContractDTO;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.pro.supplier.bean.*;
import com.ejianc.business.pro.supplier.service.*;
import com.ejianc.business.pro.supplier.utils.DateUtil;
import com.ejianc.business.pro.supplier.vo.appraise.*;
import com.ejianc.business.pro.supplier.vo.util.SupplyQueryTypeUtil;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.PunishVO;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.supplier.api.IShareSubleadersApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

@Component("yearAppraiseService")
public class YearAppraiseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "YEAY_EVALUATE";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAbnormalService abnormalService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    IProSupplierApi proSupplierApi;
    @Autowired
    private IYearService yearService;
    @Autowired
    private ILimitService limitService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private ISubleaderCanInSubService subleaderCanInSubService;
    @Autowired
    IContractPoolApi contractPoolApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IShareSubleadersApi shareSubleadersApi;

    private static final BigDecimal level1 = new BigDecimal(-10L);
    private static final BigDecimal level2 = new BigDecimal(-20L);
    private static final BigDecimal level3 = new BigDecimal(-30L);

    /**
     * @param appraiseParamVO
     * @description: 判断今日是否是推送日期，并且获取本次推送年度的起始时间
     * @return: com.ejianc.business.pro.supplier.vo.appraise.AppraiseResultVO
     * @author xuannl
     * @date: 2022/5/06
     */
    public String getStartDate(AppraiseParamVO appraiseParamVO) {
        String nowDateStr = DateUtil.format(new Date(), DateUtil.DATE);
        String substring = nowDateStr.substring(5,10);
        // 如果今日不是设置的结算周期，返回空
        if(!appraiseParamVO.getYearPushDate().equals(substring)){
            return null;
        }
        // 如果之前有过年度评价，起始日期就取上一次的年度评价日期，避免周期修改值后，取值不准确。
        // 供应商年度评价不可手动新增！！！，如后续需要支持手动新增，需要对获取起始日期重新处理！
        QueryWrapper<YearEntity> wrapper = new QueryWrapper<>();
        wrapper.isNotNull("old_start_date");
        wrapper.orderByDesc("create_time");
        List<YearEntity> list = yearService.list(wrapper);
        if(list.size() != 0){
            Date createTime = list.get(0).getCreateTime();
            return DateUtil.format(createTime, DateUtil.DATE);
        }else{
            Integer startYear = DateUtil.getYear() - 1;
            return startYear + "-" + appraiseParamVO.getYearPushDate();
        }
    }
    // 累计扣分项 (事件、过程)
    public Map<Long, SupplySubVo> sumSubGrade(List<ProcessEntity> processList, List<IncidentEntity> incidentList){
        Map<Long,SupplySubVo> supplySubMap = new HashMap<>();
        for (ProcessEntity entity:processList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());

            logger.info("ProcessEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId()+""+entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:"+supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:"+entityStr);
            if(null == supplySubVo){
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long,ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(),projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubVo1.setSjSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(BigDecimal.ZERO);
                supplySubMap.put(entity.getSupplyId(),supplySubVo1);
            }else{
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if(null == projectSubVo){
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(),projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                }else{
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSjSubGrade(supplySubVo.getSjSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }

        for (IncidentEntity entity:incidentList
        ) {
            SupplySubVo supplySubVo = supplySubMap.get(entity.getSupplyId());
            logger.info("IncidentEntity");
            logger.info(entity.getId().toString());
            logger.info(entity.getSupplyId()+""+entity.getBuckleBranch());
            entity.setBuckleBranch(null == entity.getBuckleBranch() ? BigDecimal.ZERO : entity.getBuckleBranch());
            String supplySubVoStr = JSONObject.toJSONString(supplySubVo);
            logger.info("supplySubVoStr:"+supplySubVoStr);
            String entityStr = JSONObject.toJSONString(entity);
            logger.info("entityStr:"+entityStr);

            if(null == supplySubVo){
                // 添加到project数据集
                ProjectSubVo projectSubVo1 = new ProjectSubVo();
                projectSubVo1.setPrijectId(entity.getProjectId());
                projectSubVo1.setSubGrade(entity.getBuckleBranch());
                Map<Long,ProjectSubVo> projectSubMap = new HashMap<>();
                projectSubMap.put(entity.getProjectId(),projectSubVo1);
                // 添加到供应商数据集
                SupplySubVo supplySubVo1 = new SupplySubVo();
                supplySubVo1.setSupplyId(entity.getSupplyId());
                supplySubVo1.setSubGrade(entity.getBuckleBranch());
                supplySubVo1.setGcSubGrade(entity.getBuckleBranch());
                supplySubVo1.setProjectMap(projectSubMap);
                supplySubMap.put(entity.getSupplyId(),supplySubVo1);
            }else{
                Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
                ProjectSubVo projectSubVo = projectMap.get(entity.getProjectId());
                if(null == projectSubVo){
                    // 添加到project数据集
                    ProjectSubVo projectSubVo1 = new ProjectSubVo();
                    projectSubVo1.setPrijectId(entity.getProjectId());
                    projectSubVo1.setSubGrade(entity.getBuckleBranch());
                    projectMap.put(entity.getProjectId(),projectSubVo1);
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                }else{
                    projectSubVo.setSubGrade(projectSubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setSubGrade(supplySubVo.getSubGrade().add(entity.getBuckleBranch()));
                    supplySubVo.setGcSubGrade(supplySubVo.getGcSubGrade().add(entity.getBuckleBranch()));
                }
            }
        }
        return supplySubMap;
    }
    // 获取统计数据集
    public Map<Long, SupplyBaseVo> getSupplyResult(String rule,List<ContractDTO> dtos){
        Map<Long,SupplyBaseVo> supplyBaseMap = new HashMap<>();
        for (ContractDTO dto:dtos
        ) {
            String contractType = SupplyQueryTypeUtil.get(rule, dto.getContractType());
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(dto.getSupplyId());
            // 如果供应商还未添加到map中
            if(null == supplyBaseVo){
                Map<Long,ContractDTO> contractMap = new HashMap<>();
                contractMap.put(dto.getContractId(),dto);
                // 添加项目数据集
                ProjectBaseVo projectBaseVo = new ProjectBaseVo();
                projectBaseVo.setProjectId(dto.getProjectId());
                projectBaseVo.setSupplyId(dto.getSupplyId());
                projectBaseVo.setProjectMny(dto.getContractTaxMny());
                projectBaseVo.setContracts(contractMap);
                // 添加分类数据集
                Map<Long,ProjectBaseVo> projectMap = new HashMap<>();
                projectMap.put(dto.getProjectId(),projectBaseVo);
                TypeBaseVo typeBaseVo = new TypeBaseVo();

                typeBaseVo.setContractType(contractType);
                typeBaseVo.setContractDetailType(dto.getContractType());
                typeBaseVo.setSupplyId(dto.getSupplyId());
                typeBaseVo.setTypeMny(dto.getContractTaxMny());
                typeBaseVo.setProjectMap(projectMap);
                // 添加到供应商数据集
                Map<String,TypeBaseVo> typeMap = new HashMap<>();
                typeMap.put(contractType,typeBaseVo);
                SupplyBaseVo supplyBaseVo1 = new SupplyBaseVo();
                supplyBaseVo1.setSumMny(dto.getContractTaxMny());
                supplyBaseVo1.setSupplyId(dto.getSupplyId());
                supplyBaseVo1.setTypeBaseMap(typeMap);
                supplyBaseVo1.setCount(1);
                supplyBaseVo1.addProjectIds(dto.getProjectId());
                // 汇总
                supplyBaseMap.put(supplyBaseVo1.getSupplyId(),supplyBaseVo1);
            }else{
                Map<String, TypeBaseVo> typeBaseMap = supplyBaseVo.getTypeBaseMap();
                TypeBaseVo typeBaseVo = typeBaseMap.get(contractType);
                // 如果分类还未添加到对应供应商中
                if(null == typeBaseVo){
                    Map<Long,ContractDTO> contractMap = new HashMap<>();
                    contractMap.put(dto.getContractId(),dto);
                    // 添加项目数据集
                    ProjectBaseVo projectBaseVo = new ProjectBaseVo();
                    projectBaseVo.setProjectId(dto.getProjectId());
                    projectBaseVo.setSupplyId(dto.getSupplyId());
                    projectBaseVo.setProjectMny(dto.getContractTaxMny());
                    projectBaseVo.setContracts(contractMap);
                    // 添加分类数据集
                    Map<Long,ProjectBaseVo> projectMap = new HashMap<>();
                    projectMap.put(dto.getProjectId(),projectBaseVo);
                    TypeBaseVo typeBaseVo1 = new TypeBaseVo();
                    typeBaseVo1.setContractType(contractType);
                    typeBaseVo1.setContractDetailType(dto.getContractType());
                    typeBaseVo1.setSupplyId(dto.getSupplyId());
                    typeBaseVo1.setTypeMny(dto.getContractTaxMny());
                    typeBaseVo1.setProjectMap(projectMap);
                    // 添加到供应商数据集
                    typeBaseMap.put(contractType,typeBaseVo1);
                    supplyBaseVo.setTypeBaseMap(typeBaseMap);
                    // 累计钱
                    supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                    supplyBaseVo.addProjectIds(dto.getProjectId());
                    supplyBaseVo.setCount(supplyBaseVo.getCount()+1);
                }else{
                    Map<Long, ProjectBaseVo> projectMap = typeBaseVo.getProjectMap();
                    ProjectBaseVo projectBaseVo = projectMap.get(dto.getProjectId());
                    if(null == projectBaseVo){
                        Map<Long,ContractDTO> contractMap = new HashMap<>();
                        contractMap.put(dto.getContractId(),dto);
                        // 添加项目数据集
                        ProjectBaseVo projectBaseVo1 = new ProjectBaseVo();
                        projectBaseVo1.setProjectId(dto.getProjectId());
                        projectBaseVo1.setSupplyId(dto.getSupplyId());
                        projectBaseVo1.setContracts(contractMap);
                        projectBaseVo1.setProjectMny(dto.getContractTaxMny());
                        // 添加分类数据集
                        projectMap.put(dto.getProjectId(),projectBaseVo1);
                        typeBaseVo.setProjectMap(projectMap);
                        // 累计钱
                        typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.setSumMny(supplyBaseVo.getSumMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.addProjectIds(dto.getProjectId());
                        supplyBaseVo.setCount(supplyBaseVo.getCount()+1);
                    }else{
                        Map<Long,ContractDTO> contractMap = projectBaseVo.getContracts();
                        contractMap.put(dto.getContractId(),dto);
                        // 添加项目数据集
                        projectBaseVo.setContracts(contractMap);
                        // 累计钱
                        projectBaseVo.setProjectMny(projectBaseVo.getProjectMny().add(dto.getContractTaxMny()));
                        typeBaseVo.setTypeMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.setSumMny(typeBaseVo.getTypeMny().add(dto.getContractTaxMny()));
                        supplyBaseVo.addProjectIds(dto.getProjectId());
                        supplyBaseVo.setCount(supplyBaseVo.getCount()+1);
                    }
                }
            }
        }
        return supplyBaseMap;
    }

    // 获取供应商下最大的类别额
    public TypeBaseVo getMaxType(SupplyBaseVo supplyBaseVo){
        Map<String, TypeBaseVo> typeBaseMap = supplyBaseVo.getTypeBaseMap();
        BigDecimal maxMny = BigDecimal.ZERO;
        TypeBaseVo resultVo = new TypeBaseVo();
        for (TypeBaseVo vo:typeBaseMap.values()
        ) {
            if(vo.getTypeMny().compareTo(maxMny) >= 0){
                maxMny = vo.getTypeMny();
                resultVo = vo;
            }
        }
        return resultVo;
    }

    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeA(Map<Long,SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds,String startDate){
        QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
        List<LimitEntity> list = limitService.list(wrapper);
        // 引用双键map key 供应商分类 等级 val 限额
        Table<String, Long, BigDecimal> doubleMap = HashBasedTable.create();
        for (LimitEntity limitEntity : list) {
            // 是否开启 如果限额为空代表不限制，等于没有开启
            if(limitEntity.getState() && null != limitEntity.getAllYear()){
                doubleMap.put(limitEntity.getSupplyType(),limitEntity.getGreadId(),limitEntity.getAllYear());
            }

        }
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long,GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity:gradeList
        ) {
            weightMap.put(entity.getWeight(),entity);
            weightIdMap.put(entity.getId(),entity);
        }
        // 获取异常等级
        Map<Integer,AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity:errlist
        ) {
            errWeightMap.put(entity.getWeight(),entity);
        }


        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();

        logger.info("supplyBaseMap:"+JSONObject.toJSONString(supplyBaseMap));
        for (Long supplierId:supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            logger.info("supplyBaseVo:"+JSONObject.toJSONString(supplyBaseVo));
            if(null == supplyBaseVo) {
                logger.info("根据供应商Id-{}获取到供应商信息为空，跳过该供应商！", supplierId);
                continue;
            }
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            logger.info("maxTypeVo:"+JSONObject.toJSONString(maxTypeVo));
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            if(null == supplierVO.getGradeId()) {
                logger.info("供应商Id-{}根据其现有等级信息为空，跳过该供应商！", supplierId);
                continue;
            }
            // 获取该等级下最大合同额的 最大限额
            String supplyType = maxTypeVo.getContractType();
            logger.info("supplyType:"+supplyType);
            logger.info("maxTypeVo:"+JSONObject.toJSONString(maxTypeVo));
            logger.info("doubleMap:"+JSONObject.toJSONString(doubleMap));
            BigDecimal maxMny = doubleMap.get(supplyType, supplierVO.getGradeId());
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            if(null == gradeEntity) {
                logger.info("供应商Id-{}根据其现有等级Id-{}获取到对应供应商等级信息为空，跳过该供应商！", supplierId,supplierVO.getGradeId());
                continue;
            }
            Integer nowWeight = gradeEntity.getWeight();

            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            Map<Long, ProjectSubVo> projectMap = supplySubVo.getProjectMap();
            Map<Long,BigDecimal> proSubGrade = new HashMap<>();
            for (ProjectSubVo vo:projectMap.values()
            ) {
                proSubGrade.put(vo.getPrijectId(),vo.getSubGrade());
            }
            // 调用计算规则
            CalRuleVo calRuleVo = calRuleA(nowWeight, proSubGrade, supplySubVo.getSubGrade(), supplyBaseVo.getSumMny(), maxMny, new BigDecimal(90L));
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size()+"");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);
            CommonResponse<ContractPoolVO> contractPoolVOCommonResponse = contractPoolApi.queryById(maxContract);
            if(contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null){
                ContractPoolVO data = contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }

            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if(null == gradeEntity1){
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if(null != calRuleVo.getNewErrWeight()){
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    private Long getMaxConBytype(TypeBaseVo maxTypeVo){
        Long maxContract = null;
        BigDecimal max = BigDecimal.ZERO;
        Map<Long, ProjectBaseVo> projectMap = maxTypeVo.getProjectMap();
        for (ProjectBaseVo item:projectMap.values()) {
            for (ContractDTO t:item.getContracts().values()) {
                if(t.getContractTaxMny().compareTo(max) >= 0){
                    maxContract = t.getContractId();
                }
            }
        }
        return maxContract;
    }

    /**
     *
     * @param nowWeight 原等级
     * @param proSubGrade 项目对应的扣分值
     * @param sumGrade 总扣分
     * @param sumMny 总合同额
     * @param maxMny 限制最大值
     * @param rercent 阈值百分比(整数 90、80、100)
     */
    private CalRuleVo calRuleA(Integer nowWeight,Map<Long, BigDecimal> proSubGrade,BigDecimal sumGrade,BigDecimal sumMny,BigDecimal maxMny,BigDecimal rercent){
        // 新的正常权重 异常权重
        logger.info("计算等级开始打印入参");
        logger.info("nowWeight:"+nowWeight);
        logger.info("proSubGrade:"+JSONObject.toJSONString(proSubGrade));
        logger.info("sumGrade:"+sumGrade);
        logger.info("sumMny:"+sumMny);
        logger.info("maxMny:"+maxMny);
        logger.info("rercent:"+rercent);
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 额度*倍数
        maxMny = null == maxMny ? BigDecimal.ZERO : maxMny.multiply(rercent);
        sumMny = null == sumMny ? BigDecimal.ZERO : sumMny.multiply(new BigDecimal(100L));
        // 年度得值大于-10分
        if(sumGrade.compareTo(level1) > 0){
            if(nowWeight < 9 && sumMny.compareTo(maxMny) > 0){
                // 现在的等级小于9  并且 合同额大于限额
                newWeight = nowWeight + 1;
            }else if(nowWeight == 9 && sumMny.compareTo(maxMny) > 0){
                // 现在的等级小于9  并且 合同额大于限额 并且超过三个项目 每个项目扣分小于10分
                // 是否满足增加权重规则
                boolean res = true;
                if(proSubGrade.values().size() >= 3){
                    for (BigDecimal dec:proSubGrade.values()
                    ) {
                        if(dec.compareTo(level1) <= 0){
                            res = false;
                            break;
                        }
                    }
                }else{
                    res = false;
                }
                if(res){
                    newWeight = nowWeight + 1;
                }
            }
        }else if(sumGrade.compareTo(level3) <= 0){
            newErrWeight = 10;
        }else if(sumGrade.compareTo(level2) <= 0){
            if(nowWeight > 8){
                // 现在的等级大于8
                newWeight = nowWeight - 1;
            }
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }


    /**
     * 实际按照规则计算新权重方法
     * @param sumGrade 总扣分
     */
    private CalRuleVo calRuleB(BigDecimal sumGrade){
        // 新的正常权重 异常权重
        Integer newWeight = null;
        Integer newErrWeight = null;
        // 年度扣分小于10
        if(sumGrade.compareTo(level1) >= 0){
            newWeight = 10;
        }else if(sumGrade.compareTo(level1) < 0 && sumGrade.compareTo(level2) <= 0){
            newWeight = 9;
        }else if(sumGrade.compareTo(level2) < 0 && sumGrade.compareTo(level3) <= 0){
            newWeight = 8;
        }else if(sumGrade.compareTo(level3) < 0 ){
            newErrWeight = 10;
        }
        CalRuleVo vo = new CalRuleVo();
        vo.setNewWeight(newWeight);
        vo.setNewErrWeight(newErrWeight);
        return vo;
    }



    // 计算最终扣分结果
    public List<AppraiseResultVO> calGradeB(Map<Long,SupplyBaseVo> supplyBaseMap, Map<Long, SupplierVO> shareSupplierMap, Map<Long, SupplySubVo> longSupplySubVoMap, List<Long> supplierIds,String startDate){
        // 获取等级
        Map<Integer, GradeEntity> weightMap = new HashMap<>();
        Map<Long,GradeEntity> weightIdMap = new HashMap<>();
        QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
        List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
        for (GradeEntity entity:gradeList
        ) {
            weightMap.put(entity.getWeight(),entity);
            weightIdMap.put(entity.getId(),entity);
        }
        // 获取异常等级
        Map<Integer,AbnormalEntity> errWeightMap = new HashMap<>();
        QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
        List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
        for (AbnormalEntity entity:errlist
        ) {
            errWeightMap.put(entity.getWeight(),entity);
        }
        // 开始计算
        List<AppraiseResultVO> appraiseResultVOList = new ArrayList<>();
        for (Long supplierId:supplierIds
        ) {
            SupplyBaseVo supplyBaseVo = supplyBaseMap.get(supplierId);
            // 获取大最大额度的类别
            TypeBaseVo maxTypeVo = getMaxType(supplyBaseVo);
            // 获取供应商信息(拿等级、权重)
            SupplierVO supplierVO = shareSupplierMap.get(supplierId);
            SupplySubVo supplySubVo = longSupplySubVoMap.get(supplierId);
            AppraiseResultVO appraiseResultVO = new AppraiseResultVO();
            // 获取供应商现在的等级信息
            GradeEntity gradeEntity = weightIdMap.get(supplierVO.getGradeId());
            // 计算新的权重
            CalRuleVo calRuleVo = calRuleB(supplySubVo.getSubGrade());

            appraiseResultVO.setSupplyId(supplierId);
            appraiseResultVO.setSupplyName(supplierVO.getName());
            appraiseResultVO.setCooperationProjectName(supplyBaseVo.getProjectIds().size()+"");
            // 获取最大类别下的  最大金额的合同，取他的合作单位
            Long maxContract = getMaxConBytype(maxTypeVo);
            CommonResponse<ContractPoolVO> contractPoolVOCommonResponse = contractPoolApi.queryById(maxContract);
            if(contractPoolVOCommonResponse.isSuccess() && contractPoolVOCommonResponse.getData() != null){
                ContractPoolVO data = contractPoolVOCommonResponse.getData();
                appraiseResultVO.setCooperationOrgId(data.getOrgId());
                appraiseResultVO.setCooperationOrgName(data.getOrgName());
            }
            appraiseResultVO.setPrimaryGrade(gradeEntity.getName());
            appraiseResultVO.setTotalAmount(supplyBaseVo.getSumMny());
            appraiseResultVO.setTotalNum(supplyBaseVo.getCount());
            appraiseResultVO.setProcessBranch(supplySubVo.getGcSubGrade());
            appraiseResultVO.setIncidentBranch(supplySubVo.getSjSubGrade());
            appraiseResultVO.setSupplyType(SupplyQueryTypeUtil.getEName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setSupplyTypeName(SupplyQueryTypeUtil.getName(maxTypeVo.getContractDetailType()));
            appraiseResultVO.setThiYearNum(supplyBaseVo.getCount());
            appraiseResultVO.setSupplyQueryType(maxTypeVo.getContractType());
            GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
            if(null == gradeEntity1){
                gradeEntity1 = gradeEntity;
            }
            appraiseResultVO.setGrade(gradeEntity1.getId());
            appraiseResultVO.setGradeName(gradeEntity1.getName());
            appraiseResultVO.setContractType(maxTypeVo.getContractDetailType());
            appraiseResultVO.setErrWeight(calRuleVo.getNewErrWeight());
            appraiseResultVO.setOldStartDate(startDate);
            if(null != calRuleVo.getNewErrWeight()){
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                appraiseResultVO.setPunishType(abnormalEntity.getId());
                appraiseResultVO.setPunishTypeName(abnormalEntity.getName());
            }
            appraiseResultVOList.add(appraiseResultVO);
        }
        return appraiseResultVOList;
    }


    public void sendData(List<AppraiseResultVO> appraiseResultVOList){
        List<YearEntity> yearEntities = BeanMapper.mapList(appraiseResultVOList, YearEntity.class);
        for (YearEntity entity:yearEntities
        ) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setStatus(0);
            entity.setCreateUserId(InvocationInfoProxy.getUserid());
            entity.setEndDate(new Date());
            entity.setYearDeduct(0); //默认年度评价得分为0
            entity.setSourceType("自制");
        }

        if(yearEntities.size()>0){
            yearService.saveOrUpdateBatch(yearEntities,yearEntities.size());
        }
    }

    // 获取合同维度的扣分  (包含项目扣分)
    public List<ContVo> sumSubProGrade(List<SubcontractProcessEntity> processlist,List<SubcontractIncidentEntity> incidentList){
        Map<Long,BigDecimal> con = new HashMap<>();
        Map<Long,BigDecimal> gc = new HashMap<>();
        Map<Long,BigDecimal> sj = new HashMap<>();
        BigDecimal sum = BigDecimal.ZERO;
        for (SubcontractProcessEntity entity:processlist
        ) {
            Long contractId = entity.getContractId();
            if(null == con.get(contractId)){
                con.put(contractId,entity.getBuckleBranch());
            }else{
                con.put(contractId,con.get(contractId).add(entity.getBuckleBranch()));
            }
            if(null == sj.get(contractId)){
                sj.put(contractId,entity.getBuckleBranch());
            }else{
                sj.put(contractId,sj.get(contractId).add(entity.getBuckleBranch()));
            }
            sum = ComputeUtil.safeAdd(sum, entity.getBuckleBranch());
//            sum = sum.add(entity.getBuckleBranch());
        }
        for (SubcontractIncidentEntity entity:incidentList
        ) {
            Long contractId = entity.getContractId();
            if(null == con.get(contractId)){
                con.put(contractId,entity.getBuckleBranch());
            }else{
                con.put(contractId,con.get(contractId).add(entity.getBuckleBranch()));
            }
            if(null == gc.get(contractId)){
                gc.put(contractId,entity.getBuckleBranch());
            }else{
                gc.put(contractId,gc.get(contractId).add(entity.getBuckleBranch()));
            }
//            sum = sum.add(entity.getBuckleBranch());
            sum = ComputeUtil.safeAdd(sum, entity.getBuckleBranch());
        }
        // 总合同数
        BigDecimal count = BigDecimal.valueOf(con.size());
        BigDecimal divide = BigDecimal.ZERO;
        logger.info("sum:"+sum);
        logger.info("count:"+count);
        if(sum.compareTo(BigDecimal.ZERO) != 0 && count.compareTo(BigDecimal.ZERO) != 0){
            divide = sum.divide(count,0,BigDecimal.ROUND_UP);
        }

        Map<Long, SubcontractProcessEntity> processMap = processlist.stream()
                .collect(HashMap::new,(m,s)->m.put(s.getContractId(),s),HashMap::putAll);
        Map<Long, SubcontractIncidentEntity> incidentMap = incidentList.stream()
                .collect(HashMap::new,(m,s)->m.put(s.getContractId(),s),HashMap::putAll);

        List<ContVo> resultList = new ArrayList<>();
        for (Long item:con.keySet()) {
            SubcontractProcessEntity subcontractProcessEntity = processMap.get(item);
            SubcontractIncidentEntity subcontractIncidentEntity = incidentMap.get(item);
            if(null != subcontractProcessEntity){
                ContVo contVo = getContVo(subcontractProcessEntity,con,sj,divide);
                resultList.add(contVo);
            }else{
                if((null != subcontractIncidentEntity)){
                    ContVo contVo = getContVo(subcontractIncidentEntity,con,sj,divide);
                    resultList.add(contVo);
                }else{
                    logger.info("数据出错，合同id:"+item);
                }
            }
        };
        return resultList;
    };

    private ContVo getContVo(SubcontractProcessEntity entity,Map<Long,BigDecimal> con,Map<Long,BigDecimal> sj,BigDecimal divide){
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }
    private ContVo getContVo(SubcontractIncidentEntity entity,Map<Long,BigDecimal> con,Map<Long,BigDecimal> sj,BigDecimal divide){
        ContVo contVo = new ContVo();
        contVo.setContractId(entity.getContractId());
        contVo.setContractName(entity.getContractName());
        contVo.setContractType(entity.getContractType());
        contVo.setProjectName(entity.getProjectName());
        contVo.setOrgName(entity.getCheckOrgName());
        contVo.setContractMny(entity.getContractAmount());
        contVo.setSubProGrade(con.get(entity.getContractId()));
        contVo.setSubSjGrade(sj.get(entity.getContractId()));
        contVo.setSubGcGrade(divide);
        return contVo;
    }


    // 获取合同维度的扣分  (包含项目扣分)
    public List<Map<String,Object>> sumSubProGrade2(List<SubcontractProcessEntity> processlist,List<SubcontractIncidentEntity> incidentList,Long supplyId){
        // 转为同一类型vo
        List<SubContVo> vos = new ArrayList<>();
        for (SubcontractProcessEntity entity:processlist) {
            SubContVo contVo1 = new SubContVo();
            contVo1.setHeadUserId(entity.getHeadUserId());
            contVo1.setHeadUserName(entity.getHeadUserName());
            contVo1.setContractId(entity.getContractId());
            contVo1.setContractName(entity.getContractName());
            contVo1.setContractType(entity.getContractType());
            contVo1.setProjectName(entity.getProjectName());
            contVo1.setOrgName(entity.getCheckOrgName());
            contVo1.setContractMny(entity.getContractAmount());
            contVo1.setSubProGrade(entity.getBuckleBranch()); //项目分
            contVo1.setSubSjGrade(entity.getBuckleBranch()); //事件分
            contVo1.setSubGcGrade(BigDecimal.ZERO); //过程分
            vos.add(contVo1);
        }
        for (SubcontractIncidentEntity entity:incidentList) {
            SubContVo contVo1 = new SubContVo();
            contVo1.setHeadUserId(entity.getHeadUserId());
            contVo1.setHeadUserName(entity.getHeadUserName());
            contVo1.setContractId(entity.getContractId());
            contVo1.setContractName(entity.getContractName());
            contVo1.setContractType(entity.getContractType());
            contVo1.setProjectName(entity.getProjectName());
            contVo1.setOrgName(entity.getCheckOrgName());
            contVo1.setContractMny(entity.getContractAmount());
            contVo1.setSubProGrade(entity.getBuckleBranch());//项目分
            contVo1.setSubSjGrade(BigDecimal.ZERO); //事件分
            contVo1.setSubGcGrade(entity.getBuckleBranch());//过程分
            contVo1.setProjectId(entity.getProjectId());
            vos.add(contVo1);
        }
//        vos = vos.stream().filter(u -> null != u.getHeadUserId()).collect(Collectors.toList());
        Map<Long, List<SubContVo>> map = vos.stream().collect(Collectors.groupingBy(t -> null != t.getHeadUserId() ? t.getHeadUserId() : -1L));

        List<Long> subleaderIds = map.keySet().stream().filter(item -> !item.equals(-1L)).collect(Collectors.toList());

        //查询分包负责人信息
        Map<Long, SubleadersVO> subLeaderMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(subleaderIds)) {
            Map<String, List<Long>> subLeaderParam = new HashMap<>();
            subLeaderParam.put("ids", new ArrayList<>(map.keySet()));
            logger.info("查询分包负责人列表，ids-{}", JSONObject.toJSONString(subleaderIds));
            CommonResponse<List<SubleadersVO>> dtoResp = shareSubleadersApi.getSubleaderList(subLeaderParam);
            if(!dtoResp.isSuccess()) {
                logger.error("查询分包负责人列表，ids-{}异常，{}", JSONObject.toJSONString(subleaderIds), JSONObject.toJSONString(dtoResp));
                throw new RuntimeException("查询分包负责人信息失败！");
            }
            subLeaderMap =  dtoResp.getData().stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        }

        List<Map<String,Object>> result = new ArrayList<>();
        Integer code = 1;
        List<Long> contractIds = new ArrayList<>();
        for(Map.Entry<Long, List<SubContVo>> entry : map.entrySet()) {
            Long headUserId = entry.getKey();
            List<SubContVo> list = entry.getValue();
            // 总项目额  过程扣分  总扣分 项目扣分(合同)
            BigDecimal sumCon = BigDecimal.ZERO;
            BigDecimal sumGrade = BigDecimal.ZERO;
            BigDecimal ageGcGrade = BigDecimal.ZERO;  //过程平均分
            Map<Long,BigDecimal> proGrade = new HashMap<>();

            for (SubContVo vo:list) {
                sumCon = ComputeUtil.safeAdd(sumCon, vo.getContractMny());
                sumGrade = ComputeUtil.safeAdd(sumGrade, vo.getSubProGrade());
//                gcGrade = gcGrade.add(vo.getSubGcGrade());
                BigDecimal grade = proGrade.get(vo.getContractId());
                if(null == grade){
                    proGrade.put(vo.getContractId(), vo.getSubProGrade());
                }else{
                    proGrade.put(vo.getContractId(),grade.add(vo.getSubProGrade()));
                }
            }

            // 计算对应等级

            QueryWrapper<LimitEntity> wrapper = new QueryWrapper<>();
            List<LimitEntity> limitList = limitService.list(wrapper);
            // 引用双键map key 供应商分类 等级 val 限额
            Table<String, Long, BigDecimal> doubleMap = HashBasedTable.create();
            for (LimitEntity limitEntity : limitList) {
                // 是否开启 如果限额为空代表不限制，等于没有开启
                if(limitEntity.getState() && null != limitEntity.getAllYear()){
                    doubleMap.put(limitEntity.getSupplyType(),limitEntity.getGreadId(),limitEntity.getAllYear());
                }
            }
            // 获取等级
            Map<Integer, GradeEntity> weightMap = new HashMap<>();
            Map<Long,GradeEntity> weightIdMap = new HashMap<>();
            QueryWrapper<GradeEntity> gradeWrapper = new QueryWrapper<>();
            List<GradeEntity> gradeList = gradeService.list(gradeWrapper);
            for (GradeEntity entity:gradeList ) {
                weightMap.put(entity.getWeight(),entity);
                weightIdMap.put(entity.getId(),entity);
            }
            // 获取异常等级
            Map<Integer,AbnormalEntity> errWeightMap = new HashMap<>();
            QueryWrapper<AbnormalEntity> abnormalWrapper = new QueryWrapper<>();
            List<AbnormalEntity> errlist = abnormalService.list(abnormalWrapper);
            for (AbnormalEntity entity:errlist) {
                errWeightMap.put(entity.getWeight(),entity);
            }

            SubleadersVO subleadersVO =subLeaderMap.get(headUserId);
            BigDecimal max = BigDecimal.ZERO;
            String level = "", errLevel= "";
            Integer i = 0;
            if(null != subleadersVO) {
                Long grade = subleadersVO.getGrade();
                // 现在的等级
                GradeEntity gradeEntity = weightIdMap.get(grade);
                // 最大限额
                BigDecimal labor = doubleMap.get("labor",gradeEntity.getId()) == null ? BigDecimal.ZERO : doubleMap.get("labor",gradeEntity.getId());
                BigDecimal major = doubleMap.get("major",gradeEntity.getId()) == null ? BigDecimal.ZERO : doubleMap.get("major",gradeEntity.getId());
                if(labor.compareTo(major) > 0){
                    max = labor;
                }else{
                    max = major;
                }
                CalRuleVo calRuleVo = calRuleA(gradeEntity.getWeight(), proGrade, sumGrade, sumCon, max, new BigDecimal(90L));

                GradeEntity gradeEntity1 = weightMap.get(calRuleVo.getNewWeight());
                if(null == gradeEntity1){
                    gradeEntity1 = gradeEntity;
                }
                level = gradeEntity1.getName();
                AbnormalEntity abnormalEntity = errWeightMap.get(calRuleVo.getNewErrWeight());
                errLevel = null != abnormalEntity ? abnormalEntity.getName() : null;
            }

            List<Map<String,Object>> children = new ArrayList<>();
            //计算平均分
            int conNums = proGrade.keySet().size();
            ageGcGrade = sumGrade.divide(new BigDecimal(conNums), 0, RoundingMode.UP);
            for (SubContVo vo:list) {
                if(contractIds.contains(vo.getContractId())) {
                    //相同合同只显示一条记录
                    continue;
                }
                Map<String,Object> resultMap = new HashMap<>();
                resultMap.put("headUserId",null != vo.getHeadUserId() ? vo.getHeadUserId() : "");
                resultMap.put("headUserName",vo.getHeadUserName());
                resultMap.put("contractId",vo.getContractId());
                resultMap.put("contractName",vo.getContractName());
                resultMap.put("projectId",vo.getProjectId());
                resultMap.put("projectName",vo.getProjectName());
                resultMap.put("contractMny",vo.getContractMny());
                resultMap.put("sumCon",sumCon);
                resultMap.put("gcGrade", ageGcGrade);
                resultMap.put("proGrade",proGrade.get(vo.getContractId()));
                resultMap.put("sumGrade",sumGrade);
                resultMap.put("level",level);
                resultMap.put("errLevel",errLevel);
                resultMap.put("id", UUID.randomUUID());

                if(i == 0){
                    resultMap.put("rowCol", conNums);
                }else{
                    resultMap.put("rowCol",0);
                }
                contractIds.add(vo.getContractId());
                children.add(resultMap);
            }
            Map<String,Object> map1 = new HashMap<>();
            map1.put("code",code);
            map1.put("children",children);
            map1.put("headUserId", null != headUserId && !Long.valueOf("-1").equals(headUserId) ? headUserId : "");
            map1.put("headUserName", null != subleadersVO ? subleadersVO.getName() : null);
            map1.put("sumCon",sumCon);
            map1.put("gcGrade",ageGcGrade);
            map1.put("proGrade", sumGrade);
            map1.put("level",level);
            map1.put("errLevel",errLevel);
            map1.put("id", UUID.randomUUID());
            contractIds.clear();
            result.add(map1);
        }
        return result;
    };

    // 更新供应商数据 等级 处置
    public void updateSup(YearEntity entity){
        // 更新等级
        Long grade = entity.getGrade();
        String gradeName = entity.getGradeName();
        try {
            proSupplierApi.upgradeSupplier(entity.getSupplyId(),grade,gradeName);
        }catch (Exception e){
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw,true));
            String infomsg = sw.toString();
            logger.error(infomsg);
        }
        // 更新处置方式
        if(null != entity.getPunishType()){
            PunishVO punishVO = new PunishVO();
            punishVO.setSupplierId(entity.getSupplyId());
            punishVO.setPunishType(entity.getPunishType());
            punishVO.setPunishDate(new Date());
            AbnormalEntity abnormalEntity = abnormalService.selectById(entity.getPunishType());
            if(null == abnormalEntity){
                logger.error("没有查询到对应异常等级的数据");
                return;
            }
            Date endDate = DateUtil.monthAdd(new Date(), abnormalEntity.getLastTime() == null ? 0 : abnormalEntity.getLastTime());
            punishVO.setExceptionEndDate(endDate);
            punishVO.setPunishApplyPerson(entity.getProcess());
            punishVO.setPunishGradeId(entity.getGrade());
            punishVO.setPunishGrade(entity.getGradeName());
            punishVO.setPunishOldGrade(entity.getPrimaryGrade());
            punishVO.setPunishApplyOrg(entity.getOrgName());

            String punishVOStr = JSONObject.toJSONString(punishVO);
            logger.info("punishVOStr:"+punishVOStr);
            try {
                proSupplierApi.punishSupplier(punishVO);
            }catch (Exception e){
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw,true));
                String infomsg = sw.toString();
                logger.error(infomsg);
            }
        }
    }
}
