/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pro.supplier.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pro.supplier.bean.SupplierGroupEntity;
import com.ejianc.business.pro.supplier.mapper.SupplierGroupMapper;
import com.ejianc.business.pro.supplier.service.ISupplierGroupService;
import com.ejianc.business.pro.supplier.vo.SupplierGroupVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="supplierGroupService")
public class SupplierGroupServiceImpl
extends BaseServiceImpl<SupplierGroupMapper, SupplierGroupEntity>
implements ISupplierGroupService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProSupplierApi iProSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static String SUPPLY_CODE = "pro-supply-can-in-org-nature";

    @Override
    @Transactional
    public CommonResponse<SupplierGroupVO> pushSupplierToPool(Long id, boolean updateNameFlag) {
        this.logger.info("\u63a8\u9001\u4f9b\u5e94\u5546\uff01");
        SupplierGroupEntity entity = (SupplierGroupEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("entity----{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        if (updateNameFlag && entity.getSupplierType().contains("subPerson")) {
            Integer updateLeaderNum = ((SupplierGroupMapper)this.baseMapper).updateSubLeader(entity.getCertificateCode(), entity.getName());
            this.logger.info("\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u91cf " + updateLeaderNum + " \u6761\uff01");
            if ("subPerson".equals(entity.getSupplierType())) {
                return CommonResponse.success((String)"\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6210\u529f\uff01");
            }
        }
        CommonResponse supplierVOCommonResponse = this.iProSupplierApi.selectBySupplierGroupIdOrI8Code(entity.getId(), entity.getCode());
        this.logger.info("supplierVOCommonResponse----{}", (Object)JSONObject.toJSONString((Object)supplierVOCommonResponse));
        if (!supplierVOCommonResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u4f9b\u5e94\u5546\u5e93\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        SupplierVO supplierVO = (SupplierVO)supplierVOCommonResponse.getData();
        if (null == supplierVO || null == supplierVO.getId()) {
            if (!entity.getSupplierType().contains("subPerson")) {
                throw new BusinessException("\u4f9b\u5e94\u5546\u5e93\u4e0d\u5b58\u5728\u8be5\u4f9b\u5e94\u5546\uff0c\u8bf7\u5148\u505a\u4f9b\u5e94\u5546\u51c6\u5165\uff01");
            }
            if (updateNameFlag) {
                Integer updateLeaderNum = ((SupplierGroupMapper)this.baseMapper).updateSubLeader(entity.getCertificateCode(), entity.getName());
                this.logger.info("\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6570\u91cf " + updateLeaderNum + " \u6761\uff01");
            }
            return CommonResponse.success((String)"\u66f4\u65b0\u5206\u5305\u8d1f\u8d23\u4eba\u6210\u529f\uff01");
        }
        supplierVO.setInOrOut(Integer.valueOf(StringUtils.isNotBlank((CharSequence)entity.getGroupInOrOut()) && "in".equals(entity.getGroupInOrOut()) ? 0 : 1));
        supplierVO.setFormerName(supplierVO.getName());
        supplierVO.setUnitI8Code(entity.getCode());
        supplierVO.setEnterpriseNature(entity.getEnterpriseNature());
        supplierVO.setEnterpriseNatureName(entity.getEnterpriseNatureName());
        supplierVO.setName(entity.getName());
        supplierVO.setTaxPayerIdentifier(entity.getTaxpayerNum());
        supplierVO.setRegisterTime(entity.getRegisterDate());
        supplierVO.setRegisterCountryName(entity.getRegisterCountryName());
        supplierVO.setAreaName(entity.getAreaName());
        supplierVO.setAddress(entity.getAddress());
        supplierVO.setLegal(entity.getLegalPerson());
        supplierVO.setLegalPhone(entity.getLegalPhone());
        supplierVO.setBusinessPerson(entity.getBusinessPerson());
        supplierVO.setBusinessPhone(entity.getBusinessPhone());
        supplierVO.setRegisteredCapital(entity.getRegisterMny());
        supplierVO.setTaxpayerType(entity.getTaxIdentityType());
        supplierVO.setTaxPayerTypeName(entity.getTaxIdentityTypeName());
        supplierVO.setBillingAddress(entity.getBillingAddress());
        supplierVO.setBillingPhone(entity.getBillingPhone());
        supplierVO.setBankAccountName(entity.getBankName());
        supplierVO.setBankAccountCode(entity.getBankAccount());
        supplierVO.setSupplierGroupId(id);
        supplierVO.setBlacklistFlag(entity.getBlacklistFlag());
        this.iProSupplierApi.updateSupplierByGroup(supplierVO);
        CommonResponse fileRes = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202506000003", "businessLicenseFile", String.valueOf(supplierVO.getId()), "BT200422000000028", "K1639384499212");
        this.logger.info("fileRes---{}", (Object)JSONObject.toJSONString((Object)fileRes));
        this.logger.info("pushSupplierToShare----{}", (Object)JSONObject.toJSONString((Object)supplierVO));
        this.logger.info("\u66f4\u65b0\u5408\u540c\u6807\u8bc6----" + (updateNameFlag ? "\u662f" : "\u5426"));
        if (updateNameFlag) {
            Integer updateNum = ((SupplierGroupMapper)this.baseMapper).updateContractSupplier(supplierVO.getId(), entity.getName());
            this.logger.info("\u66f4\u65b0\u5408\u540c\u6570\u91cf " + updateNum + " \u6761\uff01");
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u4f9b\u5e94\u5546\u5e93\u6210\u529f", (Object)BeanMapper.map((Object)((Object)entity), SupplierGroupVO.class));
    }

    @Override
    public CommonResponse<String> syncSupplierGroup(List<SupplierGroupVO> saveOrUpdateVOs) {
        String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
        StringBuilder authtoken = new StringBuilder();
        try {
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (userContextResponse.isSuccess()) {
                JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                this.logger.info("\u62fc\u63a5\u9274\u6743\uff1a" + authtoken.toString());
            }
        }
        catch (Exception e2) {
            this.logger.error("\u83b7\u53d6\u8c03\u5ea6\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38, ", (Throwable)e2);
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
        this.logger.info("i8\u4f20\u8f93\u96c6\u56e2\u4f9b\u5e94\u5546\u5e93\u63a5\u53e3-\u63a5\u6536\u4f20\u53c2saveOrUpdateVOs" + JSONObject.toJSONString(saveOrUpdateVOs));
        List sourceCodeList = saveOrUpdateVOs.stream().filter(e -> null != e.getCode()).map(SupplierGroupVO::getCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sourceCodeList) || sourceCodeList.size() == 0) {
            return CommonResponse.error((String)"\u63a5\u53e3\u4f20\u8f93\u5931\u8d25\uff0c\u6863\u6848\u4e3b\u952esourceId\u672a\u4f20\u503c \uff01");
        }
        ArrayList<String> createDataCodeList = new ArrayList<String>();
        final ArrayList<Long> updateDataIdList = new ArrayList<Long>();
        ArrayList<String> updateDataCodeList = new ArrayList<String>();
        final ArrayList<Long> updateNameList = new ArrayList<Long>();
        final ArrayList<SupplierGroupEntity> saveOrUpdateList = new ArrayList<SupplierGroupEntity>();
        List supplierGroupList = super.list((Wrapper)new QueryWrapper().in((Object)"code", sourceCodeList));
        Map<String, SupplierGroupEntity> supplierGroupMap = supplierGroupList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e));
        Map<Object, Object> defMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(SUPPLY_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            defMap = ((List)defDocByDefCode.getData()).stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
        }
        for (SupplierGroupVO saveOrUpdateVO : saveOrUpdateVOs) {
            SupplierGroupEntity supplierGroupEntity = null;
            if (supplierGroupMap.containsKey(saveOrUpdateVO.getCode())) {
                supplierGroupEntity = supplierGroupMap.get(saveOrUpdateVO.getCode());
                if (!supplierGroupEntity.getName().equals(saveOrUpdateVO.getName())) {
                    updateNameList.add(supplierGroupEntity.getId());
                }
                updateDataCodeList.add(supplierGroupEntity.getCode());
                updateDataIdList.add(supplierGroupEntity.getId());
            } else {
                supplierGroupEntity = new SupplierGroupEntity();
                supplierGroupEntity.setId(IdWorker.getId());
                supplierGroupEntity.setTenantId(999999L);
                supplierGroupEntity.setCode(saveOrUpdateVO.getCode());
                createDataCodeList.add(saveOrUpdateVO.getCode());
            }
            supplierGroupEntity.setName(saveOrUpdateVO.getName());
            supplierGroupEntity.setEnterpriseNatureName(saveOrUpdateVO.getEnterpriseNatureName());
            supplierGroupEntity.setShortName(saveOrUpdateVO.getShortName());
            supplierGroupEntity.setEnglishShortName(saveOrUpdateVO.getEnglishShortName());
            supplierGroupEntity.setFormerName(saveOrUpdateVO.getFormerName());
            supplierGroupEntity.setSocialCreditCode(saveOrUpdateVO.getSocialCreditCode());
            supplierGroupEntity.setTaxpayerNum(saveOrUpdateVO.getTaxpayerNum());
            supplierGroupEntity.setCertificateTypeName(saveOrUpdateVO.getCertificateTypeName());
            supplierGroupEntity.setCertificateCode(saveOrUpdateVO.getCertificateCode());
            supplierGroupEntity.setRegisterCountryName(saveOrUpdateVO.getRegisterCountryName());
            supplierGroupEntity.setGroupInOrOut(saveOrUpdateVO.getGroupInOrOut());
            supplierGroupEntity.setAreaName(saveOrUpdateVO.getAreaName());
            supplierGroupEntity.setLegalPerson(saveOrUpdateVO.getLegalPerson());
            supplierGroupEntity.setLegalPhone(saveOrUpdateVO.getLegalPhone());
            supplierGroupEntity.setSupplierTypeName(saveOrUpdateVO.getSupplierTypeName());
            supplierGroupEntity.setBlacklistFlag(saveOrUpdateVO.getBlacklistFlag());
            supplierGroupEntity.setBusinessPerson(saveOrUpdateVO.getBusinessPerson());
            supplierGroupEntity.setBusinessPhone(saveOrUpdateVO.getBusinessPhone());
            supplierGroupEntity.setMainDataCode(saveOrUpdateVO.getMainDataCode());
            supplierGroupEntity.setSourceI8Id(saveOrUpdateVO.getSourceI8Id());
            supplierGroupEntity.setMemo(saveOrUpdateVO.getMemo());
            supplierGroupEntity.setTaxIdentityType(saveOrUpdateVO.getTaxIdentityType());
            supplierGroupEntity.setTaxIdentityTypeName(saveOrUpdateVO.getTaxIdentityTypeName());
            supplierGroupEntity.setBankCode(saveOrUpdateVO.getBankCode());
            supplierGroupEntity.setBankName(saveOrUpdateVO.getBankName());
            supplierGroupEntity.setBankAccount(saveOrUpdateVO.getBankAccount());
            supplierGroupEntity.setBillingAddress(saveOrUpdateVO.getBillingAddress());
            supplierGroupEntity.setBillingPhone(saveOrUpdateVO.getBillingPhone());
            supplierGroupEntity.setRegisterDate(saveOrUpdateVO.getRegisterDate());
            supplierGroupEntity.setAddress(saveOrUpdateVO.getAddress());
            supplierGroupEntity.setRegisterMny(saveOrUpdateVO.getRegisterMny());
            supplierGroupEntity.setBusinessRange(saveOrUpdateVO.getBusinessRange());
            supplierGroupEntity.setTimeOut(saveOrUpdateVO.getTimeOut());
            supplierGroupEntity.setBusinessLicenseBase64(saveOrUpdateVO.getBusinessLicenseBase64());
            supplierGroupEntity.setBusinessLicensePath(saveOrUpdateVO.getBusinessLicensePath());
            if (null != supplierGroupEntity.getSupplierTypeName()) {
                switch (supplierGroupEntity.getSupplierTypeName()) {
                    case "\u4f01\u4e1a": {
                        supplierGroupEntity.setSupplierType("enterprise");
                        break;
                    }
                    case "\u4e2a\u4eba": {
                        supplierGroupEntity.setSupplierType("person");
                        break;
                    }
                    case "\u4e2a\u4eba,\u5206\u5305\u8d1f\u8d23\u4eba": {
                        supplierGroupEntity.setSupplierType("person,subPerson");
                        break;
                    }
                    default: {
                        supplierGroupEntity.setSupplierType("subPerson");
                    }
                }
            }
            this.logger.info("defMap------" + JSONObject.toJSONString(defMap));
            if (defMap.containsKey(supplierGroupEntity.getEnterpriseNatureName())) {
                supplierGroupEntity.setEnterpriseNature((Long)defMap.get(supplierGroupEntity.getEnterpriseNatureName()));
            } else {
                this.logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u6587\u672c\u5bf9\u5e94\u81ea\u5b9a\u4e49\u6863\u6848---code" + supplierGroupEntity.getCode());
            }
            if (null == supplierGroupEntity.getSyncTime()) {
                supplierGroupEntity.setSyncTime(new Date());
            }
            supplierGroupEntity.setLatestUpdateTime(new Date());
            saveOrUpdateList.add(supplierGroupEntity);
        }
        super.saveOrUpdateBatch(saveOrUpdateList, saveOrUpdateList.size(), false);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SupplierGroupServiceImpl.this.logger.info("\u8fdb\u5165\u7ebf\u7a0b\uff01");
                String initContextUrl = SupplierGroupServiceImpl.this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
                String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
                StringBuilder authtoken = new StringBuilder();
                try {
                    CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
                    if (userContextResponse.isSuccess()) {
                        JSONObject userContext = ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                        authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
                        SupplierGroupServiceImpl.this.logger.info("\u62fc\u63a5\u9274\u6743\uff1a" + authtoken.toString());
                    }
                }
                catch (Exception e) {
                    SupplierGroupServiceImpl.this.logger.error("\u83b7\u53d6\u8c03\u5ea6\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38, ", (Throwable)e);
                }
                InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
                for (SupplierGroupEntity entity : saveOrUpdateList) {
                    SupplierGroupServiceImpl.this.uploadFile(entity);
                }
                SupplierGroupServiceImpl.this.logger.info("\u66f4\u65b0\u9644\u4ef6\u6570" + saveOrUpdateList.size());
                if (updateDataIdList.size() > 0) {
                    SupplierGroupServiceImpl.this.logger.info("\u66f4\u65b0id\u96c6\u5408--updateDataIdList--" + JSONObject.toJSONString((Object)updateDataIdList));
                    SupplierGroupServiceImpl.this.logger.info("\u66f4\u65b0\u5408\u540cid\u96c6\u5408--updateNameList--" + JSONObject.toJSONString((Object)updateNameList));
                    Iterator iterator = updateDataIdList.iterator();
                    while (iterator.hasNext()) {
                        Long id;
                        SupplierGroupServiceImpl.this.pushSupplierToPool(id, updateNameList.contains(id = (Long)iterator.next()));
                    }
                    SupplierGroupServiceImpl.this.logger.info("\u4fee\u6539\u4f9b\u5e94\u5546" + updateDataIdList.size());
                }
                SupplierGroupServiceImpl.this.logger.info("\u7ebf\u7a0b\u7ed3\u675f\uff01");
            }
        });
        thread.start();
        this.logger.info("\u7ebf\u7a0b\u540e\u8f93\u51fa");
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01");
    }

    private void uploadFile(SupplierGroupEntity entity) {
        this.logger.info("\u9644\u4ef6\u66f4\u65b0\uff01");
        ArrayList<String> businessLicenseListBase64 = new ArrayList<String>();
        ArrayList<String> businessLicenseList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)entity.getBusinessLicenseBase64())) {
            businessLicenseListBase64.add(entity.getBusinessLicenseBase64());
        }
        this.logger.info("\u63a5\u6536\u9644\u4ef6\u5730\u5740\uff1a" + JSONObject.toJSONString((Object)entity.getBusinessLicensePath()));
        if (null != entity.getBusinessLicensePath()) {
            businessLicenseList.addAll(Arrays.asList(entity.getBusinessLicensePath()));
        }
        this.logger.info("\u63a5\u6536\u9644\u4ef6\u5730\u5740\u8f6c\u6362\uff1a" + JSONObject.toJSONString(businessLicenseList));
        if (CollectionUtils.isNotEmpty(businessLicenseListBase64)) {
            AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
            attachmentVO.setBillType("EJCBT202506000003");
            attachmentVO.setSourceId(entity.getId().toString());
            attachmentVO.setSourceType("payBill");
            attachmentVO.setHandleImg(Boolean.valueOf(false));
            attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
            attachmentVO.setFileList(businessLicenseListBase64);
            this.attachmentApi.uploadForBase64(attachmentVO);
        }
        if (CollectionUtils.isNotEmpty(businessLicenseList)) {
            ArrayList list = new ArrayList();
            businessLicenseList.forEach(e -> {
                this.logger.info("filePath--------\uff1a" + e);
                AttachmentVO attachmentVO = new AttachmentVO();
                attachmentVO.setBillType("EJCBT202506000003");
                attachmentVO.setSourceId(entity.getId());
                attachmentVO.setSourceType("payBill");
                attachmentVO.setFilePath(e);
                int index = e.indexOf("&fileName=");
                int indexEnd = e.indexOf("&dbToken");
                String fileName = e.substring(index + 10, indexEnd);
                attachmentVO.setFileName(fileName);
                list.add(attachmentVO);
            });
            CommonResponse stringCommonResponse = this.attachmentApi.uploadByUrl(list);
            this.logger.info("\u4f20\u8f93\u9644\u4ef6\u4fe1\u606f----" + stringCommonResponse.getMsg());
        }
    }
}

