package com.ejianc.business.purchase.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 采购策划-历史-明细
 * 
 * @author generator
 * 
 */
public class SchemeHistoryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 主表主键
    private String purchaseType; // 采购类别
    private String purchaseWay; // 采购方式
    private String memo; // 备注
    private Long sourceId; // 来源主键
    private String subScope; // 分包范围
    private String valuationModel; // 计价模式
    private String materialNum; // 物资数量
    private BigDecimal incomeMny; // 上游收入金额
    private BigDecimal purchaseMny; // 预计采购额
    private BigDecimal surplusMny; // 盈余(±)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date purchaseDate; // 预计采购时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterDate; // 计划进场时间
    private String payScale; // 付款比例
    private String payWay; // 支付方式
    private String certification; // 分包资质要求
    private Integer duration; // 工期/供货期(月)
    private String sectionDivision; // 标段划分
    private String unitInfo; // 寻源单位信息
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseWay() {
        return purchaseWay;
    }

    public void setPurchaseWay(String purchaseWay) {
        this.purchaseWay = purchaseWay;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSubScope() {
        return subScope;
    }

    public void setSubScope(String subScope) {
        this.subScope = subScope;
    }
    public String getValuationModel() {
        return valuationModel;
    }

    public void setValuationModel(String valuationModel) {
        this.valuationModel = valuationModel;
    }
    public String getMaterialNum() {
        return materialNum;
    }

    public void setMaterialNum(String materialNum) {
        this.materialNum = materialNum;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }
    public Date getEnterDate() {
        return enterDate;
    }

    public void setEnterDate(Date enterDate) {
        this.enterDate = enterDate;
    }
    public String getPayScale() {
        return payScale;
    }

    public void setPayScale(String payScale) {
        this.payScale = payScale;
    }
    public String getPayWay() {
        return payWay;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }
    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }
    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    public String getSectionDivision() {
        return sectionDivision;
    }

    public void setSectionDivision(String sectionDivision) {
        this.sectionDivision = sectionDivision;
    }
    public String getUnitInfo() {
        return unitInfo;
    }

    public void setUnitInfo(String unitInfo) {
        this.unitInfo = unitInfo;
    }
    
}
