package com.ejianc.business.purchase.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.purchase.vo.SchemeChangeDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 采购策划-变更
 * 
 * @author generator
 * 
 */
public class SchemeChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目主键
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织
    private String billCode; // 单据编码
    private Long structureType; // 结构类型：1、全浇灌；2、框架结构；3钢结构；4砖混结构；5框架剪力墙结构
    private Integer planDateNum; // 项目工期
    private Long employeeId; // 经办人主键
    private String employeeName; // 经办人
    private Long deptId; // 经办部门主键
    private String deptName; // 经办部门
    private String memo; // 备注
    private BigDecimal contractTaxMny; // 项目总造价
    private BigDecimal incomeMny; // 上游收入金额合计
    private BigDecimal purchaseMny; // 预计采购额合计
    private BigDecimal surplusMny; // 盈余合计
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 策划日期
    private Integer changeVersion; // 变更版本
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private String changeReason; // 变更原因
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Long sourceId; // 来源主键
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String historyBillCode;
    
    private List<SchemeChangeDetailVO> detailList = new ArrayList<>(); // 采购策划-变更-明细

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getStructureType() {
        return structureType;
    }

    @ReferDeserialTransfer
    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }

    public Integer getPlanDateNum() {
        return planDateNum;
    }

    public void setPlanDateNum(Integer planDateNum) {
        this.planDateNum = planDateNum;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getHistoryBillCode() {
        return historyBillCode;
    }

    public void setHistoryBillCode(String historyBillCode) {
        this.historyBillCode = historyBillCode;
    }

    public List<SchemeChangeDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<SchemeChangeDetailVO> detailList) {
        this.detailList = detailList;
     }
}
