package com.ejianc.business.purchase.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.purchase.bean.SchemeChangeDetailEntity;
/**
 * 采购策划-变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_purchase_scheme_change")
public class SchemeChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目主键
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="structure_type")
    private Long structureType; // 结构类型：1、全浇灌；2、框架结构；3钢结构；4砖混结构；5框架剪力墙结构
    @TableField(value="plan_date_num")
    private Integer planDateNum; // 项目工期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="dept_id")
    private Long deptId; // 经办部门主键
    @TableField(value="dept_name")
    private String deptName; // 经办部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 项目总造价
    @TableField(value="income_mny")
    private BigDecimal incomeMny; // 上游收入金额合计
    @TableField(value="purchase_mny")
    private BigDecimal purchaseMny; // 预计采购额合计
    @TableField(value="surplus_mny")
    private BigDecimal surplusMny; // 盈余合计
    @TableField(value="bill_date")
    private Date billDate; // 策划日期
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_status")
    private String changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="source_id")
    private Long sourceId; // 来源主键
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="schemeChangeDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<SchemeChangeDetailEntity> detailList = new ArrayList<>(); // 采购策划-变更-明细
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getStructureType() {
        return structureType;
    }

    public void setStructureType(Long structureType) {
        this.structureType = structureType;
    }
    public Integer getPlanDateNum() {
        return planDateNum;
    }

    public void setPlanDateNum(Integer planDateNum) {
        this.planDateNum = planDateNum;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public BigDecimal getPurchaseMny() {
        return purchaseMny;
    }

    public void setPurchaseMny(BigDecimal purchaseMny) {
        this.purchaseMny = purchaseMny;
    }
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public String getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(String changeStatus) {
        this.changeStatus = changeStatus;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    
    public List<SchemeChangeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SchemeChangeDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
