package com.ejianc.business.purchase.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.cons.CommonConstant;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.service.ISchemeChangeService;
import com.ejianc.business.purchase.vo.SchemeChangeVO;

/**
 * 采购策划-变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("schemeChange")
public class SchemeChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PURCHASE_SCHEME_CHANGE";//此处需要根据实际修改

    @Autowired
    private ISchemeChangeService service;

    @Autowired
    private ISchemeService billService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SchemeChangeVO> saveOrUpdate(@RequestBody SchemeChangeVO saveOrUpdateVO) {
    	SchemeChangeEntity entity = BeanMapper.map(saveOrUpdateVO, SchemeChangeEntity.class);

        // 校验同一个项目只能存在一个自由态或审批中的单据
        service.validateProjectId(entity.getSourceId(), entity.getId(), "重复新增");

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

        // 更新原单据变更信息
        LambdaUpdateWrapper<SchemeEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.set(SchemeEntity::getChangeId, entity.getId());
        wrapper.set(SchemeEntity::getChangeStatus, CommonConstant.CHANGE_ING);
        wrapper.set(SchemeEntity::getChangeCode, entity.getBillCode());
        wrapper.eq(SchemeEntity::getId, entity.getSourceId());
        billService.update(wrapper);

    	SchemeChangeVO vo = BeanMapper.map(entity, SchemeChangeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeChangeVO> queryDetail(Long id) {
    	SchemeChangeEntity entity = service.selectById(id);
    	SchemeChangeVO vo = BeanMapper.map(entity, SchemeChangeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeChangeVO> vos) {
        if(CollectionUtils.isEmpty(vos)){
            return CommonResponse.success("删除成功！");
        }
        List<Long> ids = vos.stream().map(SchemeChangeVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<SchemeChangeEntity> list = service.queryList(param);
        for (SchemeChangeEntity vo : list) {
            LambdaUpdateWrapper<SchemeEntity> updateWrapper = new LambdaUpdateWrapper<>();
            if (vo.getChangeVersion() == 1) {
                updateWrapper.set(SchemeEntity::getChangeStatus, CommonConstant.CHANGE_NO);
            } else {
                updateWrapper.set(SchemeEntity::getChangeStatus, CommonConstant.CHANGE_OVER);
            }
            updateWrapper.eq(SchemeEntity::getId, vo.getSourceId());
            billService.update(updateWrapper);
        }
        service.removeByIds(vos.stream().map(SchemeChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SchemeChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SchemeChangeEntity> page = service.queryPage(param,false);
        IPage<SchemeChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SchemeChangeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SchemeChange-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSchemeChangeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SchemeChangeVO>> refSchemeChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SchemeChangeEntity> page = service.queryPage(param,false);
        IPage<SchemeChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SchemeChangeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 根据原单据主键查询变更单信息
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetailChange", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SchemeChangeVO> queryDetailChange(@RequestParam Long id) {
        SchemeChangeVO vo = service.queryDetailChange(id);
        return CommonResponse.success(vo);
    }

    /**
     * 变更历史记录
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryChangeHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<SchemeChangeVO>> queryChangeHistory(@RequestParam Long id) {
        List<SchemeChangeVO> vo = service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }

    /**
     * @Description validateProjectId 只能存在一个自由态或审批中的单据
     * @param id ID
     */
    @RequestMapping(value = "/validateProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> validateProjectId(@RequestParam("sourceId") Long sourceId, @RequestParam(value = "id", required = false) Long id) {
        String msg = service.validateProjectId(sourceId, id, "重复新增");
        return CommonResponse.success("校验成功！", msg);
    }
}
