package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.vo.SchemeHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchase.mapper.SchemeHistoryMapper;
import com.ejianc.business.purchase.bean.SchemeHistoryEntity;
import com.ejianc.business.purchase.service.ISchemeHistoryService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 采购策划-历史
 * 
 * @author generator
 * 
 */
@Service("schemeHistoryService")
public class SchemeHistoryServiceImpl extends BaseServiceImpl<SchemeHistoryMapper, SchemeHistoryEntity> implements ISchemeHistoryService{

    @Override
    public SchemeHistoryVO queryDetailByChangeId(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("changeId", new Parameter(QueryParam.EQ, id));
        List<SchemeHistoryEntity> list = super.queryList(param);
        if(CollectionUtils.isEmpty(list)){
            return new SchemeHistoryVO();
        }
        SchemeHistoryEntity entity = super.selectById(list.get(0).getId());
        return BeanMapper.map(entity, SchemeHistoryVO.class);
    }
}
