/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.mapper.SchemeChangeMapper;
import com.ejianc.business.purchase.service.ISchemeChangeService;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.business.purchase.utils.EntityUtil;
import com.ejianc.business.purchase.vo.SchemeChangeDetailVO;
import com.ejianc.business.purchase.vo.SchemeChangeVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeChangeService")
public class SchemeChangeServiceImpl
extends BaseServiceImpl<SchemeChangeMapper, SchemeChangeEntity>
implements ISchemeChangeService {
    @Autowired
    private ISchemeService billService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public SchemeChangeVO queryDetailChange(Long id) {
        SchemeEntity entity = (SchemeEntity)((Object)this.billService.selectById(id));
        this.validateProjectId(entity.getId(), null, "\u91cd\u590d\u65b0\u589e");
        SchemeChangeVO vo = (SchemeChangeVO)BeanMapper.map((Object)((Object)entity), SchemeChangeVO.class);
        for (SchemeChangeDetailVO detail : vo.getDetailList()) {
            detail.setSourceId(detail.getId());
            detail.setRowState("add");
            EntityUtil.clearInvalidData(detail);
        }
        vo.setSourceId(vo.getId());
        vo.setBillState(null);
        vo.setChangeReason(null);
        vo.setBillCode(null);
        vo.setChangeVersion(Integer.valueOf(vo.getChangeVersion() == null ? 1 : vo.getChangeVersion() + 1));
        vo.setChangeDate(new Date());
        EntityUtil.clearInvalidData(vo);
        vo.setId(Long.valueOf(IdWorker.getId()));
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202504000026", "attachMgr", String.valueOf(vo.getId()), "EJCBT202504000027", "attachMgr");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(id), "EJCBT202504000026", "file", String.valueOf(vo.getId()), "EJCBT202504000027", "file");
        return vo;
    }

    @Override
    public List<SchemeChangeVO> queryChangeHistory(Long id) {
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter("eq", (Object)id));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("changeVersion", "desc");
        List list = super.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<SchemeChangeVO>();
        }
        List result = BeanMapper.mapList((Iterable)list, SchemeChangeVO.class);
        for (SchemeChangeVO vo : result) {
            String historyBillCode = vo.getBillCode() + "-" + (vo.getChangeVersion() - 1);
            vo.setHistoryBillCode(historyBillCode);
        }
        return result;
    }

    @Override
    public String validateProjectId(Long sourceId, Long id, String operation) {
        List list;
        List freeList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter("eq", (Object)sourceId));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isNotEmpty(freeList = (list = super.queryList(queryParam, false)).stream().filter(x -> 1 != x.getBillState() && 3 != x.getBillState()).collect(Collectors.toList()))) {
            throw new BusinessException("\u8be5\u91c7\u8d2d\u7b56\u5212\u5b58\u5728\u975e\u751f\u6548\u6001\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u80fd" + operation + "!");
        }
        return "\u6821\u9a8c\u6210\u529f\uff01";
    }
}

