/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.service.ISchemeChangeService;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.business.purchase.service.IThreeSubPlanService;
import com.ejianc.business.purchase.vo.SchemeChangeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"schemeChange"})
public class SchemeChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PURCHASE_SCHEME_CHANGE";
    @Autowired
    private ISchemeChangeService service;
    @Autowired
    private ISchemeService billService;
    @Autowired
    private IThreeSubPlanService planService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SchemeChangeVO> saveOrUpdate(@RequestBody SchemeChangeVO saveOrUpdateVO) {
        SchemeChangeEntity entity = (SchemeChangeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SchemeChangeEntity.class));
        this.service.validateProjectId(entity.getSourceId(), entity.getId(), "\u91cd\u590d\u65b0\u589e");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)entity.getProjectId()));
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        List planList = this.planService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)planList)) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5b58\u5728\u975e\u751f\u6548\u6001\u7684\u4e09\u4e2a\u6708\u6eda\u52a8\u5206\u5305\u670d\u52a1\u8ba1\u5212\uff0c\u4e0d\u80fd\u4fdd\u5b58!");
        }
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.set(SchemeEntity::getChangeId, (Object)entity.getId());
        wrapper.set(SchemeEntity::getChangeStatus, (Object)"2");
        wrapper.set(SchemeEntity::getChangeCode, (Object)entity.getBillCode());
        wrapper.eq(BaseEntity::getId, (Object)entity.getSourceId());
        this.billService.update((Wrapper)wrapper);
        SchemeChangeVO vo = (SchemeChangeVO)BeanMapper.map((Object)((Object)entity), SchemeChangeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemeChangeVO> queryDetail(Long id) {
        SchemeChangeEntity entity = (SchemeChangeEntity)((Object)this.service.selectById(id));
        SchemeChangeVO vo = (SchemeChangeVO)BeanMapper.map((Object)((Object)entity), SchemeChangeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SchemeChangeVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", ids));
        List list = this.service.queryList(param);
        for (SchemeChangeEntity vo : list) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            if (vo.getChangeVersion() == 1) {
                updateWrapper.set(SchemeEntity::getChangeStatus, (Object)"1");
            } else {
                updateWrapper.set(SchemeEntity::getChangeStatus, (Object)"3");
            }
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getSourceId());
            this.billService.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SchemeChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SchemeChange-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSchemeChangeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SchemeChangeVO>> refSchemeChangeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SchemeChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailChange"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SchemeChangeVO> queryDetailChange(@RequestParam Long id) {
        SchemeChangeVO vo = this.service.queryDetailChange(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryChangeHistory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SchemeChangeVO>> queryChangeHistory(@RequestParam Long id) {
        List<SchemeChangeVO> vo = this.service.queryChangeHistory(id);
        return CommonResponse.success(vo);
    }

    @RequestMapping(value={"/validateProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateProjectId(@RequestParam(value="sourceId") Long sourceId, @RequestParam(value="id", required=false) Long id) {
        String msg = this.service.validateProjectId(sourceId, id, "\u91cd\u590d\u65b0\u589e");
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }
}

