/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.purchase.bean.SubPlanEntity;
import com.ejianc.business.purchase.service.ISubPlanService;
import com.ejianc.business.purchase.utils.DateUtil;
import com.ejianc.business.sync.bean.SyncRecordsEntity;
import com.ejianc.business.sync.consts.HTConstants;
import com.ejianc.business.sync.vo.FileDto;
import com.ejianc.business.sync.vo.PlanDto;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="subPlan")
public class SubPlanBpmServiceImpl
implements ICommonBusinessService {
    public static final String SYNC_RECORD_QUEUE = "purchase_record_queue";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${spring.cloud.config.profile}")
    private String profile;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISubPlanService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        SubPlanEntity entity = (SubPlanEntity)((Object)this.service.selectById(billId));
        this.sendMq(entity);
        return CommonResponse.success();
    }

    public String sendMq(SubPlanEntity entity) {
        SyncRecordsEntity record = new SyncRecordsEntity();
        record.setOperatorId(InvocationInfoProxy.getUserid());
        record.setOperatorName(this.sessionManager.getUserContext().getUserName());
        record.setPushDate(new Date());
        record.setTenantId(InvocationInfoProxy.getTenantid());
        record.setCreateUserCode(InvocationInfoProxy.getUsercode());
        record.setCreateTime(new Date());
        record.setHandleType("syncPlan");
        String url = HTConstants.PLAN_REQ_HOST + "/hjjc/v1/addPurchaseDemandPlan";
        record.setUrl(url);
        PlanDto vo = this.transferDto(entity);
        record.setData(JSONObject.toJSONString((Object)vo));
        MqMessage mqMessage = new MqMessage();
        mqMessage.setBody((Object)record);
        this.rabbitTemplate.convertAndSend("purchase_record_queue_" + this.profile, (Object)mqMessage);
        return "\u6d88\u606f\u53d1\u9001MQ\u961f\u5217\u6210\u529f\uff01";
    }

    private PlanDto transferDto(SubPlanEntity entity) {
        PlanDto vo = new PlanDto();
        vo.setOutPlanNo(HTConstants.HT_UNIT_CODE + "_" + entity.getId());
        vo.setTitle(entity.getPlanName());
        vo.setPlanAtm(entity.getSubjectMny());
        vo.setStatus("40");
        vo.setRemark(entity.getMemo());
        vo.setAttachment(null);
        vo.setCreateDate(DateUtil.formatDate(entity.getCreateDate(), "yyyyMMddHHmmss"));
        vo.setCreateUser(HTConstants.HT_INVENTED_ACCOUNT);
        vo.setCreateUserId(HTConstants.HT_INVENTED_EMP_ID);
        vo.setCreateUserName(HTConstants.HT_INVENTED_EMP_NAME);
        vo.setCreateDeptCode(HTConstants.HT_INVENTED_DEPT_CODE);
        vo.setCreateDeptName(HTConstants.HT_INVENTED_DEPT_NAME);
        vo.setCreateOrgCode(HTConstants.HT_INVENTED_ORG_CODE);
        vo.setCreateOrgName(HTConstants.HT_INVENTED_ORG_NAME);
        vo.setSysCode("HJJC");
        vo.setCreatePlateCode(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_CODE);
        vo.setCreatePlateName(HTConstants.HT_ACTUAL_DEMAND_PLAN_ORG_NAME);
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(entity.getId(), null, null, null);
        if (fileResp.isSuccess()) {
            ArrayList<FileDto> attachment = new ArrayList<FileDto>();
            for (AttachmentVO file : (List)fileResp.getData()) {
                FileDto dto = new FileDto();
                dto.setFileName(file.getFileName());
                dto.setFileType(FileUtils.getFileExt((String)file.getFileName(), (Boolean)false));
                dto.setFileSize(String.valueOf(file.getFileSize()));
                dto.setDownloadUrl(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + file.getId());
                attachment.add(dto);
            }
            vo.setAttachment(attachment);
        }
        return vo;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

