package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.purchase.mapper.SchemeMapper;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.service.ISchemeService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 采购策划
 * 
 * @author generator
 * 
 */
@Service("schemeService")
public class SchemeServiceImpl extends BaseServiceImpl<SchemeMapper, SchemeEntity> implements ISchemeService{

    @Override
    public String validateProjectId(Long projectId, Long id, String operation) {
        // 同一个项目只能存在一个单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        if(id != null){
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<SchemeEntity> list = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException("该项目下已存在采购策划，不能" + operation + "!");
        }
        return "校验成功！";
    }
}
