/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.ejianc.business.purchase.bean.SchemeChangeEntity;
import com.ejianc.business.purchase.bean.SchemeEntity;
import com.ejianc.business.purchase.bean.SchemeHistoryEntity;
import com.ejianc.business.purchase.service.ISchemeChangeService;
import com.ejianc.business.purchase.service.ISchemeHistoryService;
import com.ejianc.business.purchase.service.ISchemeService;
import com.ejianc.business.purchase.utils.EntityUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="schemeChange")
public class SchemeChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISchemeChangeService service;
    @Autowired
    private ISchemeService billService;
    @Autowired
    private ISchemeHistoryService historyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("--------------\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\uff0c\u5904\u7406\u4e1a\u52a1");
        SchemeChangeEntity change = (SchemeChangeEntity)((Object)this.service.selectById(billId));
        SchemeEntity bill = (SchemeEntity)((Object)this.billService.selectById(change.getSourceId()));
        this.logger.info("--------------\u540c\u6b65\u539f\u5355\u636e\u5230\u5386\u53f2\u8868");
        SchemeHistoryEntity history = (SchemeHistoryEntity)((Object)BeanMapper.map((Object)((Object)bill), SchemeHistoryEntity.class));
        Long historyId = IdWorker.getId();
        history = EntityUtil.clearInvalidEntity(history, SchemeHistoryEntity.class);
        history.setId(historyId);
        this.historyService.saveOrUpdate((Object)history, false);
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(bill.getId()), "EJCBT202504000026", "attachMgr", String.valueOf(history.getId()), "EJCBT202504000026", "attachMgr");
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(bill.getId()), "EJCBT202504000026", "file", String.valueOf(history.getId()), "EJCBT202504000026", "file");
        this.logger.info("--------------\u540c\u6b65\u53d8\u66f4\u5230\u539f\u5355\u636e");
        bill.setChangeStatus("3");
        bill.setChangeVersion(change.getChangeVersion());
        bill.setChangeReason(change.getChangeReason());
        bill.setChangeDate(change.getChangeDate());
        bill.setBillDate(change.getBillDate());
        bill.setEmployeeId(change.getEmployeeId());
        bill.setEmployeeName(change.getEmployeeName());
        bill.setDeptId(change.getDeptId());
        bill.setDeptName(change.getDeptName());
        bill.setIncomeMny(change.getIncomeMny());
        bill.setPurchaseMny(change.getPurchaseMny());
        bill.setSurplusMny(change.getSurplusMny());
        EntityUtil.syncDetail(bill, change, "sourceId");
        this.billService.saveOrUpdate((Object)bill, false);
        this.logger.info("--------------\u5904\u7406\u53d8\u66f4\u9644\u4ef6");
        this.attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "attachMgr", String.valueOf(bill.getId()), "EJCBT202504000026", "attachMgr", true);
        this.attachmentApi.copyFiles(String.valueOf(billId), billTypeCode, "file", String.valueOf(bill.getId()), "EJCBT202504000026", "file", true);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u6682\u4e0d\u652f\u6301\u56de\u9000\u529f\u80fd!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

