package com.ejianc.business.purchasingmanagement.api;


import com.ejianc.business.purchasingmanagement.hystrix.ReceiptHystrix;
import com.ejianc.business.purchasingmanagement.vo.WeighingInfoVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.ejianc.framework.core.response.CommonResponse;

/**
 * 中建科技项目rpc服务
 * 关闭生产任务单自动生成销售单
 * @author cJ
 *saveWeighinginfo
 */
@FeignClient(name= "ejc-purchasingmanagement-web", url="${common.env.feign-client-url}", path="ejc-purchasingmanagement-web", fallback = ReceiptHystrix.class)
public interface WeighinginfoApi {


	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@PostMapping("/api/purchasingmanagement/receiptApi/saveWeighinginfo")
	CommonResponse<WeighinginfoApi> saveWeighinginfo(@RequestBody WeighingInfoVO WeighingInfoVO);



}
