package com.ejianc.business.purchasingmanagement.api;

import com.ejianc.business.purchasingmanagement.hystrix.PurchaseListHystrix;

import com.ejianc.business.purchasingmanagement.vo.PurchasetransportationVO;
import com.ejianc.business.purchasingmanagement.vo.Request2VO;
import com.ejianc.business.purchasingmanagement.vo.RequestVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
@FeignClient(name= "ejc-purchasingmanagement-web", url="${common.env.feign-client-url}", path="ejc-purchasingmanagement-web", fallback = PurchaseListHystrix.class)
public interface PurchaseListApi {
    /**
    * @Description saveOrUpdate 采购合同列表
    */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/contractList")
    CommonResponse<PurchaseListApi> contractList(@RequestBody RequestVO requestVO);


    /**
     * @Description saveOrUpdate 供应商付款单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/receiptList")
    CommonResponse<PurchaseListApi> receiptList(@RequestBody RequestVO requestVO);


    /**
     * @Description saveOrUpdate 运输商付款单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/transportersReceiptList")
    CommonResponse<PurchaseListApi> transportersReceiptList(@RequestBody RequestVO requestVO);

    /**
     * @Description saveOrUpdate 采购运输单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shippingList")
    CommonResponse<PurchaseListApi> shippingList(@RequestBody RequestVO requestVO);


    /**
     * @Description saveOrUpdate 供应商发票列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/supplierinvoiceList")
    CommonResponse<PurchaseListApi> supplierinvoiceList(@RequestBody RequestVO requestVO);


    /**
     * @Description saveOrUpdate 运输商发票列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shippersinvoiceList")
    CommonResponse<PurchaseListApi> shippersinvoiceList(@RequestBody RequestVO requestVO);


    /**
     * @Description  运输单详情
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/shipping")
    CommonResponse<PurchaseListApi> shipping(@RequestBody  RequestVO requestVO);



    /**
     * @Description  运输单保存
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/saveShipping")
    CommonResponse<PurchaseListApi> saveShipping(@RequestBody PurchasetransportationVO purchasetransportationVO);

    /**
     * @Description saveOrUpdate 采购运输单列表
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/supplierShippingList")
    CommonResponse<PurchaseListApi> supplierShippingList(@RequestBody Request2VO requestVO);

    /**
     * @Description saveOrUpdate 采购合同列表根据原材料查询
     */
    @PostMapping("/api/purchasingmanagement/purchaseListApi/contractListByID")
    CommonResponse<PurchaseListApi> contractListByID(@RequestBody RequestVO requestVO);


}
