package com.ejianc.business.purchasingmanagement.api;

import com.ejianc.business.purchasingmanagement.hystrix.SelectHystrix;
import com.ejianc.business.purchasingmanagement.vo.MaterialAcceptanceVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/9/13
 * @description:
 */
@FeignClient(name= "ejc-purchasingmanagement-web", url="${common.env.feign-client-url}", path="ejc-purchasingmanagement-web", fallback = SelectHystrix.class)
public interface SelectApi {
    /**
     * 查询原材料收货信息
     * @param materialId 原材料id
     * @param acceptanceDate 验收日期
     * @return 原材料验收相关信息
     */
    @GetMapping(value = "/api/purchasingmanagement/selectApi/querymaterialacceptance")
    CommonResponse<MaterialAcceptanceVO> queryMaterialAcceptance(@RequestParam(value = "materialId")String materialId, @RequestParam(value = "acceptanceDate")String acceptanceDate);
}
