package com.ejianc.business.purchasingmanagement.api;

import com.ejianc.business.purchasingmanagement.hystrix.PurchaseListHystrix;
import com.ejianc.business.purchasingmanagement.vo.AccountInfoVO;
import com.ejianc.business.purchasingmanagement.vo.RequestVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name= "ejc-purchasingmanagement-web", url="${common.env.feign-client-url}", path="ejc-purchasingmanagement-web", fallback = PurchaseListHystrix.class)
public interface AccountInfoApi {

    /**
     * @Description accountInfo 供应商账号信息
     */
    @PostMapping("/api/purchasingmanagement/accountInfoApi/accountInfo")
    CommonResponse<AccountInfoApi> accountInfo(@RequestBody AccountInfoVO accountInfoVO);


    /**
     * @Description accountDetil 供应商账号详情
     */
    @PostMapping("/api/purchasingmanagement/accountInfoApi/accountDetil")
    CommonResponse<AccountInfoApi> accountDetil(@RequestBody RequestVO requestVO);

    /**
     * @Description accountDetil 供应商账号详情
     */
    @PostMapping("/api/purchasingmanagement/accountInfoApi/accountUpdate")
    CommonResponse<AccountInfoApi> accountUpdate(@RequestBody AccountInfoVO accountInfoVO);





}
