package com.ejianc.business.supervise.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目监理-监理日志
 * 
 * @author generator
 * 
 */
public class SuperviseLogVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date logDate; // 记录日期
    private String weather; // 天气
    private String amTemperature; // 上午温度
    private String pmTemperature; // 下午温度
    private String noonTemperature; // 午间温度
    private Integer workNum; // 工作人数
    private Long wbsId; // 施工部位id
    private String wbsName; // 施工部位
    private String constructionName; // 施工人员
    private String emergencyMemo; // 突发事件
    private String workMemo; // 工作内容
    private String inspectMemo; // 检查检验情况
    private String materialMemo; // 材料、设备进度
    private String designChangesMemo; // 设计变更及工程签证
    private String fileRecordMemo; // 工程联系单及往来文件记录
    private String memo; // 其他内容
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getLogDate() {
        return logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }
    public String getWeather() {
        return weather;
    }

    public void setWeather(String weather) {
        this.weather = weather;
    }
    public String getAmTemperature() {
        return amTemperature;
    }

    public void setAmTemperature(String amTemperature) {
        this.amTemperature = amTemperature;
    }
    public String getPmTemperature() {
        return pmTemperature;
    }

    public void setPmTemperature(String pmTemperature) {
        this.pmTemperature = pmTemperature;
    }
    public String getNoonTemperature() {
        return noonTemperature;
    }

    public void setNoonTemperature(String noonTemperature) {
        this.noonTemperature = noonTemperature;
    }
    public Integer getWorkNum() {
        return workNum;
    }

    public void setWorkNum(Integer workNum) {
        this.workNum = workNum;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getWbsId() {
        return wbsId;
    }
    @ReferDeserialTransfer
    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }
    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }
    public String getConstructionName() {
        return constructionName;
    }

    public void setConstructionName(String constructionName) {
        this.constructionName = constructionName;
    }
    public String getEmergencyMemo() {
        return emergencyMemo;
    }

    public void setEmergencyMemo(String emergencyMemo) {
        this.emergencyMemo = emergencyMemo;
    }
    public String getWorkMemo() {
        return workMemo;
    }

    public void setWorkMemo(String workMemo) {
        this.workMemo = workMemo;
    }
    public String getInspectMemo() {
        return inspectMemo;
    }

    public void setInspectMemo(String inspectMemo) {
        this.inspectMemo = inspectMemo;
    }
    public String getMaterialMemo() {
        return materialMemo;
    }

    public void setMaterialMemo(String materialMemo) {
        this.materialMemo = materialMemo;
    }
    public String getDesignChangesMemo() {
        return designChangesMemo;
    }

    public void setDesignChangesMemo(String designChangesMemo) {
        this.designChangesMemo = designChangesMemo;
    }
    public String getFileRecordMemo() {
        return fileRecordMemo;
    }

    public void setFileRecordMemo(String fileRecordMemo) {
        this.fileRecordMemo = fileRecordMemo;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
