package com.ejianc.business.supervise.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目监理-监理周报
 * 
 * @author generator
 * 
 */
public class SuperviseWeeklyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String year; // 年份
    private String weeks; // 周数
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private Long progressStageId; // 进展阶段id
    private String progressStageName; // 进展阶段
    private String progressStageStatus; // 推进状态
    private String monthMemo; // 本月目标节点
    private String weekMemo; // 本周进展
    private String nextWeekMemo; // 下周计划
    private String problemMemo; // 需协调解决的问题
    private String memo; // 备注
    private BigDecimal projectProgress; // 项目进度
    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public String getWeeks() {
        return weeks;
    }

    public void setWeeks(String weeks) {
        this.weeks = weeks;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProgressStageId() {
        return progressStageId;
    }
    @ReferDeserialTransfer
    public void setProgressStageId(Long progressStageId) {
        this.progressStageId = progressStageId;
    }
    public String getProgressStageName() {
        return progressStageName;
    }

    public void setProgressStageName(String progressStageName) {
        this.progressStageName = progressStageName;
    }
    public String getProgressStageStatus() {
        return progressStageStatus;
    }

    public void setProgressStageStatus(String progressStageStatus) {
        this.progressStageStatus = progressStageStatus;
    }
    public String getMonthMemo() {
        return monthMemo;
    }

    public void setMonthMemo(String monthMemo) {
        this.monthMemo = monthMemo;
    }
    public String getWeekMemo() {
        return weekMemo;
    }

    public void setWeekMemo(String weekMemo) {
        this.weekMemo = weekMemo;
    }
    public String getNextWeekMemo() {
        return nextWeekMemo;
    }

    public void setNextWeekMemo(String nextWeekMemo) {
        this.nextWeekMemo = nextWeekMemo;
    }
    public String getProblemMemo() {
        return problemMemo;
    }

    public void setProblemMemo(String problemMemo) {
        this.problemMemo = problemMemo;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getProjectProgress() {
        return projectProgress;
    }

    public void setProjectProgress(BigDecimal projectProgress) {
        this.projectProgress = projectProgress;
    }
    
}
